@extends('admin.layouts.master')
@section('title', __('add_blog'))
@section('content')

    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-12">
                <h3 class="section-title">{{ __('add_blog') }}</h3>
                <form action="{{ route('admin.blog.store') }}" method="post" enctype="multipart/form-data" class="crud-form">
                    @csrf
                    <div class="row">
                        <div class="col-sm-6">
                            <div class="default-tab-list default-tab-list-v2  bg-white redious-border p-20 p-sm-30">
                                <h3 class="section-title"> {{ __('blog_information') }} </h3>
                                <div class="mb-4">
                                    <label for="title" class="form-label"> {{ __('blog_title') }} <span
                                            class="text-danger">*</span> </label>
                                    <input type="text" class="form-control rounded-2" id="title" name="title"
                                        value="{{ old('title') }}" placeholder="{{ __('blog_title') }}">
                                    <div class="nk-block-des text-danger">
                                        <p class="error">{{ $errors->first('title') }}</p>
                                    </div>
                                </div>
                                <div class="mb-4">
                                    <label for="slug" class="form-label"> {{ __('blog_slug') }} <span
                                            class="text-danger">*</span> </label>
                                    <input type="text" class="form-control rounded-2" id="slug" name="slug"
                                        value="{{ old('slug') }}" placeholder="{{ __('blog_slug') }}">
                                    <div class="nk-block-des text-danger">
                                        <p class="error">{{ $errors->first('slug') }}</p>
                                    </div>
                                </div>
                                <div class="mb-4">
                                    <label for="category" class="form-label">{{ __('blog_category') }} </label>
                                    <select class="form-select form-select-lg mb-3 select2 with_search" name="category_id"
                                        id="category">
                                        <option value="0"> {{ __('select_blog_category') }}</option>
                                        @foreach ($categories as $category)
                                            <option value="{{ $category->id }}"
                                                {{ old('category') == $category->id ? 'selected' : '' }}>
                                                {{ $category->title }} </option>
                                        @endforeach
                                    </select>
                                    <div class="nk-block-des text-danger">
                                        <p class="error">{{ $errors->first('category') }}</p>
                                    </div>
                                </div>
                                <div class="mb-4">
                                    <label for="blog_description" class="form-label d-flex justify-content-between">
                                        <span>{{ __('blog_description') }}</span>
                                        <small class="generate-button">
                                            <button data-url="{{ route('ai-helper') }}"
                                                data-type="blog_description" data-title="" data-id="blog_description"
                                                class="generate-content text-decoration-none text-danger">
                                                <span><i class="las la-robot"></i></span>
                                            </button>
                                        </small>
                                    </label>
                                    <textarea name="description" class="form-control rounded-2" id="blog_description" cols="30" rows="4">{{ old('description') }}</textarea>
                                    <div class="nk-block-des text-danger">
                                        <p class="error">{{ $errors->first('description') }}</p>
                                    </div>
                                </div>

                                <div class="d-flex gap-12 align-items-center justify-content-between sandbox_mode_div mb-4">
                                    <input type="hidden" name="status" value="1">
                                    <label class="form-label" for="status"> {{ __('status') }} </label>
                                    <div class="setting-check">
                                        <input type="checkbox" value="1" id="status" checked class="sandbox_mode">
                                        <label for="status"></label>
                                    </div>
                                </div>
                                <div class="d-flex gap-12 align-items-center justify-content-between sandbox_mode_div mb-4">
                                    <input type="hidden" name="is_top" value="0">
                                    <label class="form-label" for="is_top"> {{ __('top_news') }} </label>
                                    <div class="setting-check">
                                        <input type="checkbox" value="1" id="is_top" class="sandbox_mode">
                                        <label for="is_top"></label>
                                    </div>
                                </div>
                                <button type="submit" class="btn sg-btn-primary">{{ __('submit') }}</button>
                                @include('layouts.loading_button', ['class' => 'btn sg-btn-primary'])
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="default-tab-list default-tab-list-v2  bg-white redious-border p-20 p-sm-30">
                                <h3 class="section-title"> {{ __('blog_banner') }} </h3>
                                <div class="input_file_div d-flex align-items-center gap-3">
                                    <div class="mb-3 w-75">
                                        <label for="thumbUpload"
                                            class="form-label mb-1">{{ __('blog_banner_(500x750)') }}</label>
                                        <label for="thumbUpload" class="file-upload-text"></label>
                                        <input class="d-none file_picker" type="file" name="image" id="thumbUpload"
                                            accept=".jpg,.png">
                                        <div class="nk-block-des text-danger">
                                            <p class="error"></p>
                                        </div>
                                    </div>
                                    <div class="selected-files d-flex flex-wrap gap-20">
                                        <div class="selected-files-item">
                                            <img class="selected-img"
                                                src="{{ getFileLink('blog', '', 'blogs', '240x240') }}" alt="image">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="default-tab-list default-tab-list-v2  bg-white redious-border p-20 p-sm-30 mt-3">
                                <h3 class="section-title"> {{ __('seo_and_marketing') }} </h3>
                                <div class="mb-4">
                                    <label for="seo_title" class="form-label"> {{ __('seo_title') }} </label>
                                    <input type="text" class="form-control rounded-2" id="seo_title" name="seo_title"
                                        value="{{ old('seo_title') }}" placeholder="{{ __('seo_title') }}">
                                    <div class="nk-block-des text-danger">
                                        <p class="error">{{ $errors->first('seo_title') }}</p>
                                    </div>
                                </div>
                                <div class="mb-4">
                                    <label for="meta_description" class="form-label d-flex justify-content-between">
                                        <span>{{ __('meta_description') }}</span>
                                        <small class="generate-button">
                                            <button data-url="{{ route('ai-helper') }}"
                                                data-type="blog_meta_description" data-title=""
                                                data-id="meta_description"
                                                class="generate-content text-decoration-none text-danger">
                                                <span><i class="las la-robot"></i></span>
                                            </button>
                                        </small>
                                    </label>
                                    <textarea name="meta_description" id="meta_description" cols="30" rows="3"
                                        class="form-control rounded-2" placeholder="{{ __('meta_description') }}">{{ old('meta_description') }}</textarea>
                                    <div class="nk-block-des text-danger">
                                        <p class="error">{{ $errors->first('meta_description') }}</p>
                                    </div>
                                </div>
                                <div class="mb-4">
                                    <label for="focus_keyword" class="form-label"> {{ __('focus_keyword') }} </label>
                                    <input type="text" class="form-control rounded-2" id="focus_keyword"
                                        name="focus_keyword" value="{{ old('focus_keyword') }}"
                                        placeholder="{{ __('focus_focus_keyword') }}">
                                    <div class="nk-block-des text-danger">
                                        <p class="error">{{ $errors->first('focus_keyword') }}</p>
                                    </div>
                                    <p class="text-muted">({{ __('use_comma_to_separate_focus_keyword') }})</p>
                                </div>
                                <div class="mb-4">
                                    <label for="tags" class="form-label"> {{ __('tags') }} </label>
                                    <input type="text" class="form-control rounded-2" id="tags" name="tags"
                                        value="{{ old('tags') }}" placeholder="{{ __('tags') }}">
                                    <div class="nk-block-des text-danger">
                                        <p class="error">{{ $errors->first('tags') }}</p>
                                    </div>
                                    <p class="text-muted">({{ __('use_comma_to_separate_tags') }})</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>

    @endsection
    @push('js')
        <script>
            "use strict";
            $('#blog_description').summernote({
                height: 210,
            });
            $("#title").keyup(function() {
                var Text = $(this).val();
                Text = Text.toLowerCase();
                Text = Text.replace(/[^\w ]+/g, '');
                Text = Text.replace(/ +/g, '-');
                $("#slug").val(Text);
            });
        </script>
    @endpush
