<form action="{{ route('admin.ads.post_roll.store') }}" method="post" enctype="multipart/form-data"
    class="form-validate form">
    @csrf
    <input type="hidden" name="type" value="post_roll">
    <div class="mb-2 mt-3">
        <label for="title" class="form-label"> {{ __('ad_title') }} <span class="text-danger">*</span> </label>
        <input type="text" class="form-control rounded-2" id="title" name="title" value="{{ old('title') }}"
            placeholder="{{ __('ad_title') }}">
        <div class="nk-block-des text-danger">
            <p class="error">{{ $errors->first('title') }}</p>
        </div>
    </div>
    
    {{-- URL Section --}}
    <div class="ad-url-section">
        <div class="mb-2">
            <label for="ad_url" class="form-label">{{ __('video_file_url') }} <span
                    class="text-danger">*</span></label>
            <input type="url" class="form-control" id="ad_url" name="video_link" value="{{ old('video_link') }}"
                placeholder="https://example.com/ad.mp4">
            <div class="nk-block-des text-danger">
                <p class="error">{{ $errors->first('ad_url') }}</p>
            </div>
        </div>
    </div>

    <div class="mb-2 ads-local">
        <label for="redirect_url" class="form-label"> {{ __('redirect_url') }}
        </label>
        <input type="text" class="form-control rounded-2" id="redirect_url" name="redirect_url"
            value="{{ old('redirect_url') }}" placeholder="{{ __('ads_redirect_url') }}">
        <div class="nk-block-des text-danger">
            <p class="error">{{ $errors->first('redirect_url') }}</p>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-6">
            <div class="mb-2">
                <label for="ad_duration" class="form-label">{{ __('ad_duration_seconds') }} <span class="text-danger">*</span></label>
                <input type="number" class="form-control rounded-2" id="ad_duration" name="ad_duration"
                    value="{{ old('ad_duration') }}" min="1"
                    placeholder="{{ __('how_long_the_ad_will_play') }}">
                <div class="nk-block-des text-danger">
                    <p class="error">{{ $errors->first('ad_duration') }}</p>
                </div>
            </div>
        </div>
        <div class="col-sm-6">
            <div class="mb-2">
                <label for="skip_after" class="form-label">{{ __('skip_after_seconds') }} <span class="text-danger">*</span></label>
                <input type="number" class="form-control rounded-2" id="skip_after" name="skip_after"
                    value="{{ old('skip_after') }}" min="0"
                    placeholder="{{ __('allow_skip_after_how_many_seconds') }}">
                <div class="nk-block-des text-danger">
                    <p class="error">{{ $errors->first('skip_after') }}</p>
                </div>
            </div>
        </div>
        <div class="col-sm-6">

            <div class="mb-2">
                <label for="start_date" class="form-label"> {{ __('start_date') }} <span class="text-danger">*</span></label>
                <input type="datetime-local" class="form-control datetimePicker rounded-2" id="start_date" name="start_date"
                    value="{{ old('start_date') }}">
                <div class="nk-block-des text-danger">
                    <p class="error">{{ $errors->first('start_date') }}</p>
                </div>
            </div>
        </div>
        <div class="col-sm-6">
            <div class="mb-2">
                <label for="end_date" class="form-label"> {{ __('end_date') }} <span class="text-danger">*</span></label>
                <input type="datetime-local" class="form-control datetimePicker rounded-2" id="end_date" name="end_date"
                    value="{{ old('end_date') }}">
                <div class="nk-block-des text-danger">
                    <p class="error">{{ $errors->first('end_date') }}</p>
                </div>
            </div>
        </div>
        <div class="col-sm-6">
            <div class="d-flex gap-12 align-items-center justify-content-between my-2">
                <input type="hidden" name="status" value="1">
                <label class="form-label" for="status"> {{ __('ads_status') }} </label>
                <div class="setting-check">
                    <input type="checkbox" value="1" id="status" checked class="sandbox_mode">
                    <label for="status"></label>
                </div>
            </div>
        </div>
    </div>


    <button type="submit" class="btn sg-btn-primary">{{ __('submit') }}</button>
    @include('layouts.loading_button', ['class' => 'btn sg-btn-primary'])
</form>

<script>
"use strict";
    // Start date-time picker
    flatpickr(".datetimePicker", {
        defaultDate: new Date(),
        enableTime: true,
        enableSeconds: true,
        dateFormat: "Y-m-d H:i:S",
        time_24hr: true,
        minDate: "today"
    });
</script>
