<form action="{{route('admin.ads.update', ['id'=>$ads->id])}}" method="post" enctype="multipart/form-data" class="form-validate form">
    @csrf
    <div class="mb-2 mt-3">
        <label for="title" class="form-label"> {{ __('title') }} <span class="text-danger">*</span> </label>
        <input type="text" class="form-control rounded-2" id="title" name="title" value="{{ old('title', $ads->title) }}" placeholder="{{ __('ads_title') }}">
        <div class="nk-block-des text-danger">
            <p class="error">{{ $errors->first('title') }}</p>
        </div>
    </div>
    <input type="hidden" name="id" value="{{ $ads->id }}">
    <div class="mb-2">
        <label for="type" class="form-label">{{ __('ads_type') }} <span class="text-danger">*</span> </label>
        <select class="form-select form-select-lg mb-3 select2 with_search" name="type"
            id="ads_type">
            <option value=""> {{__('select_ads_type')}} </option>
            <option value="google" {{$ads->type == 'google' ? 'selected':''}}> {{__('google_ads')}} </option>
            <option value="local" {{$ads->type == 'local' ? 'selected':''}}> {{__('local_ads')}} </option>
            <option value="mp4" {{$ads->type == 'mp4' ? 'selected':''}}> {{__('video_link')}} </option>
        </select>
        <div class="nk-block-des text-danger">
            <p class="error">{{ $errors->first('type') }}</p>
        </div>
    </div>
    <div class="mb-2 ads-local {{$ads->type != 'local' ? 'd-none':''}}">
        <label for="start_date" class="form-label"> {{ __('start_date') }} <span class="text-danger">*</span> </label>
        <input type="datetime-local" class="form-control rounded-2" id="start_date" name="start_date" value="{{ old('start_date', $ads->start_date) }}" placeholder="{{ __('ads_start_date') }}">
        <div class="nk-block-des text-danger">
            <p class="error">{{ $errors->first('start_date') }}</p>
        </div>
    </div>
    <div class="mb-2 ads-local {{$ads->type != 'local' ? 'd-none':''}}">
        <label for="end_date" class="form-label"> {{ __('end_date') }} <span class="text-danger">*</span> </label>
        <input type="datetime-local" class="form-control rounded-2" id="end_date" name="end_date" value="{{ old('end_date', $ads->end_date) }}" placeholder="{{ __('ads_end_date') }}">
        <div class="nk-block-des text-danger">
            <p class="error">{{ $errors->first('end_date') }}</p>
        </div>
    </div>
    <div class="mb-2 ads-local {{$ads->type != 'local' ? 'd-none':''}}">
        <label for="redirect_url" class="form-label"> {{ __('redirect_url') }} <span class="text-danger">*</span> </label>
        <input type="text" class="form-control rounded-2" id="redirect_url" name="redirect_url" value="{{ old('redirect_url', $ads->redirect_url) }}" placeholder="{{ __('ads_redirect_url') }}">
        <div class="nk-block-des text-danger">
            <p class="error">{{ $errors->first('redirect_url') }}</p>
        </div>
    </div>

    <div class="mb-2 ads-local {{$ads->type != 'local' ? 'd-none':''}}">
        <label class="form-label mb-1"> {{ __('ads_banner') }} <span class="text-danger">*</span> </label>
        <label for="banner" class="file-upload-text">
            <p id="selected-file-name">{{ __('select_file_from_device') }}</p>
            <span class="file-btn">{{ __('choose_file') }}</span>
        </label>
        <input class="d-none file_picker" type="file" id="banner" name="banner" accept=".jpg,.png">
        <div class="nk-block-des text-danger">
            <p class="banner_error error">{{ $errors->first('banner') }}</p>
        </div>
    </div>


    <div class="mb-2 ads-google {{$ads->type != 'google' ? 'd-none':''}}">
        <label for="content" class="form-label"> {{ __('content') }} <span class="text-danger">*</span> </label>
        <textarea name="content" id="content" cols="30" rows="4" class="form-control rounded-2"
            placeholder="{{ __('ads_content') }}">{{ old('content', $ads->content) }}</textarea>
        <div class="nk-block-des text-danger">
            <p class="error">{{ $errors->first('content') }}</p>
        </div>
    </div>

    <div class="mb-2 ads-mp4 {{$ads->type != 'mp4' ? 'd-none':''}}">
        <label for="video_link" class="form-label"> {{__('video_link')}} <span class="text-danger">*</span> </label>
        <input type="url" class="form-control rounded-2" id="video_link" name="video_link" value="{{ old('video_link', $ads->video_link) }}" placeholder="https://example.com/video.mp4">
        <div class="nk-block-des text-danger">
            <p class="error">{{ $errors->first('video_link') }}</p>
        </div>
    </div>

    <div class="d-flex gap-12 align-items-center justify-content-between sandbox_mode_div mb-2">
        <input type="hidden" name="status" value="{{$ads->status}}">
        <label class="form-label" for="status"> {{__('ads_status')}} </label>
        <div class="setting-check">
            <input type="checkbox" value="1" id="status" class="sandbox_mode" {{$ads->status == 1 ? 'checked':''}}>
            <label for="status"></label>
        </div>
    </div>
    
    <button type="submit" class="btn sg-btn-primary">{{ __('submit') }}</button>
    @include('layouts.loading_button',['class' => 'btn sg-btn-primary'])
</form>
<script>
"use strict";
    $('.with_search').select2({
        dropdownParent: $('#ajaxModal') // Ensure dropdown appears inside modal
    });
    $("#ads_type").on('change', function(){
        var type = $("#ads_type").val();
        if(type == 'local') {
            $('.ads-local').removeClass('d-none')
            $('.ads-google, .ads-mp4').addClass('d-none')
        } else if(type == 'google') {
            $('.ads-google').removeClass('d-none')
            $('.ads-local, .ads-mp4').addClass('d-none')
        } else if(type == 'mp4') {
            $('.ads-mp4').removeClass('d-none')
            $('.ads-local, .ads-google').addClass('d-none')
        } else {
            $('.ads-local, .ads-google, .ads-mp4').addClass('d-none')
        }
    })
    document.getElementById('banner').addEventListener('change', function(e) {
        const fileName = e.target.files.length ? e.target.files[0].name : '';
        document.getElementById('selected-file-name').textContent = fileName ? fileName : '';
    });
</script>