<?php

namespace Database\Seeders;

use App\Models\MovieLanguage;
use Illuminate\Database\Seeder;
use Illuminate\Support\Str;
use Carbon\Carbon;

class MovieLanguageSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $languages = [
            'English',
            'Spanish',
            'Hindi',
            'Bengali',
            'French',
            'German',
            'Italian',
            'Japanese',
            'Korean',
            'Mandarin',
            'Portuguese',
            'Russian',
            'Arabic',
            'Turkish',
            'Dutch',
            'Vietnamese',
            'Thai',
            'Indonesian',
            'Tamil',
            'Telugu',
        ];

        foreach ($languages as $language) {
            MovieLanguage::insert([
                'name' => $language,
                'slug' => Str::slug($language),
                'description' => null,
                'status' => 1,
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ]);
        }
    }
}
