<?php

namespace Database\Seeders;

use Carbon\Carbon;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class DemoDataSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {

        $genres = [
            [
                'name' => 'Action',
                'slug' => 'action',
                'description' => null,
                'icon' => null,
                'featured' => 0,
                'status' => 1,
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
            [
                'name' => 'Thriller',
                'slug' => 'thriller',
                'description' => null,
                'icon' => null,
                'featured' => 0,
                'status' => 1,
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
            [
                'name' => 'Crime',
                'slug' => 'crime',
                'description' => null,
                'icon' => null,
                'featured' => 0,
                'status' => 1,
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
            [
                'name' => 'Comedy',
                'slug' => 'comedy',
                'description' => null,
                'icon' => null,
                'featured' => 0,
                'status' => 1,
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
            [
                'name' => 'Animation',
                'slug' => 'animation',
                'description' => null,
                'icon' => null,
                'featured' => 0,
                'status' => 1,
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
            [
                'name' => 'Fantasy',
                'slug' => 'fantasy',
                'description' => null,
                'icon' => null,
                'featured' => 0,
                'status' => 1,
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
            [
                'name' => 'Music',
                'slug' => 'music',
                'description' => null,
                'icon' => null,
                'featured' => 0,
                'status' => 1,
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
            [
                'name' => 'Family',
                'slug' => 'family',
                'description' => null,
                'icon' => null,
                'featured' => 0,
                'status' => 1,
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
        ];

        DB::table('genres')->insert($genres);

        $stars = [
            [
                'id' => 1,
                'star_name' => 'Scarlett Johansson',
                'slug' => 'scarlett-johansson',
                'star_type' => 'actor',
                'country_id' => null,
                'star_dob' => null,
                'ranking' => null,
                'gender' => null,
                'industries' => null,
                'star_image' => '{"original_image":"https://placehold.co/100x100"}',
                'star_desc' => null,
                'view' => 1,
                'status' => 1,
                'facebook' => null,
                'twitter' => null,
                'instagram' => null,
                'created_at' => '2025-08-11 08:46:40',
                'updated_at' => '2025-08-11 08:46:40',
            ],
            [
                'id' => 2,
                'star_name' => 'Jonathan Bailey',
                'slug' => 'jonathan-bailey',
                'star_type' => 'actor',
                'country_id' => null,
                'star_dob' => null,
                'ranking' => null,
                'gender' => null,
                'industries' => null,
                'star_image' => '{"original_image":"https://placehold.co/100x100"}',
                'star_desc' => null,
                'view' => 1,
                'status' => 1,
                'facebook' => null,
                'twitter' => null,
                'instagram' => null,
                'created_at' => '2025-08-11 08:46:40',
                'updated_at' => '2025-08-11 08:46:40',
            ],
            [
                'id' => 3,
                'star_name' => 'Mahershala Ali',
                'slug' => 'mahershala-ali',
                'star_type' => 'actor',
                'country_id' => null,
                'star_dob' => null,
                'ranking' => null,
                'gender' => null,
                'industries' => null,
                'star_image' => '{"original_image":"https://placehold.co/100x100"}',
                'star_desc' => null,
                'view' => 1,
                'status' => 1,
                'facebook' => null,
                'twitter' => null,
                'instagram' => null,
                'created_at' => '2025-08-11 08:46:40',
                'updated_at' => '2025-08-11 08:46:40',
            ],
            [
                'id' => 4,
                'star_name' => 'Rupert Friend',
                'slug' => 'rupert-friend',
                'star_type' => 'actor',
                'country_id' => null,
                'star_dob' => null,
                'ranking' => null,
                'gender' => null,
                'industries' => null,
                'star_image' => '{"original_image":"https://placehold.co/100x100"}',
                'star_desc' => null,
                'view' => 1,
                'status' => 1,
                'facebook' => null,
                'twitter' => null,
                'instagram' => null,
                'created_at' => '2025-08-11 08:46:40',
                'updated_at' => '2025-08-11 08:46:40',
            ],
            [
                'id' => 5,
                'star_name' => 'Manuel Garcia-Rulfo',
                'slug' => 'manuel-garcia-rulfo',
                'star_type' => 'actor',
                'country_id' => null,
                'star_dob' => null,
                'ranking' => null,
                'gender' => null,
                'industries' => null,
                'star_image' => '{"original_image":"https://placehold.co/100x100"}',
                'star_desc' => null,
                'view' => 1,
                'status' => 1,
                'facebook' => null,
                'twitter' => null,
                'instagram' => null,
                'created_at' => '2025-08-11 08:46:40',
                'updated_at' => '2025-08-11 08:46:40',
            ]
        ];
        DB::table('stars')->insert($stars);

        DB::table('movies')->insert([
            [
                'id' => 1,
                'title' => 'Jurassic World Rebirth',
                'thumbnail' => '{"original_image":"https://placehold.co/500x750"}',
                'poster' => '{"original_image":"https://placehold.co/1920x1080"}',
                'slug' => 'jurassic-world-rebirth',
                'seo_title' => 'Jurassic World Rebirth',
                'description' => 'Five years after the events of Jurassic World Dominion, covert operations expert Zora Bennett is contracted to lead a skilled team on a top-secret mission to secure genetic material from the world\'s three most massive dinosaurs. When Zora\'s operation intersects with a civilian family whose boating expedition was capsized, they all find themselves stranded on an island where they come face-to-face with a sinister, shocking discovery that\'s been hidden from the world for decades.',
                'stars' => '["1","2","3"]',
                'director' => '["3"]',
                'writer' => '["4"]',
                'rating' => NULL,
                'release' => '2025-07-01',
                'country' => '["194"]',
                'genre' => '["1","2","3"]',
                'language' => '["2","5"]',
                'video_type' => '1',
                'runtime' => '134',
                'video_quality' => '1',
                'is_original' => 0,
                'is_trending' => 1,
                'is_featured' => 1,
                'is_recommended' => 1,
                'is_blockbuster' => 1,
                'is_real_life_story' => 0,
                'status' => 1,
                'trailer' => 0,
                'trailler_youtube_source' => NULL,
                'enable_download' => 1,
                'focus_keyword' => '',
                'meta_description' => 'Five years after the events of Jurassic World Dominion, covert operations expert Zora Bennett is contracted to lead a skilled team on a top-secret mission to secure genetic material from the world\'s three most massive dinosaurs. When Zora\'s operation intersects with a civilian family whose boating expedition was capsized, they all find themselves stranded on an island where they come face-to-face with a sinister, shocking discovery that\'s been hidden from the world for decades.',
                'tags' => '',
                'imdb_rating' => '6.399',
                'is_tvseries' => 0,
                'total_rating' => 1,
                'is_free' => 1,
                'is_rental' => 0,
                'rental_price' => NULL,
                'rental_duration' => NULL,
                'rental_type' => NULL,
                'today_view' => 0,
                'weekly_view' => 0,
                'monthly_view' => 0,
                'total_view' => 1,
                'last_view_reset' => '2025-04-03 18:00:00',
                'last_ep_added' => '2025-04-03 18:00:00',
                'imdbid' => '1234821',
                'tmdb_id' => 1234821,
                'created_at' => '2025-08-11 08:46:42',
                'updated_at' => '2025-08-11 08:46:42',
            ]

        ]);


        $tvShows = [
            [
                'id' => 1,
                'title' => 'Wednesday',
                'thumbnail' => json_encode(['original_image' => 'https://placehold.co/500x750']),
                'poster' => json_encode(['original_image' => 'https://placehold.co/1920x1080']),
                'slug' => 'wednesday',
                'seo_title' => 'Wednesday',
                'description' => 'Smart, sarcastic and a little dead inside, Wednesday Addams investigates twisted mysteries while making new friends — and foes — at Nevermore Academy.',
                'stars' => json_encode(["1","2","3","4"]),
                'director' => json_encode(["3"]),
                'writer' => json_encode(["4"]),
                'rating' => null,
                'release' => '2022-11-23',
                'country' => json_encode(["194"]),
                'genre' => json_encode(["1", "2", "4"]),
                'language' => json_encode(["2"]),
                'video_type' => 1,
                'runtime' => null,
                'video_quality' => 1,
                'is_original' => 1,
                'is_featured' => 1,
                'is_blockbuster' => 0,
                'is_recommended' => 1,
                'is_real_life_story' => 0,
                'status' => 1,
                'trailer' => 0,
                'trailler_youtube_source' => null,
                'enable_download' => 1,
                'focus_keyword' => '',
                'meta_description' => 'Smart, sarcastic and a little dead inside, Wednesday Addams investigates twisted mysteries while making new friends — and foes — at Nevermore Academy.',
                'tags' => '',
                'imdb_rating' => '8.408',
                'is_tvseries' => 1,
                'is_popular' => 0,
                'total_rating' => 1,
                'is_free' => 1,
                'is_rental' => 0,
                'rental_price' => null,
                'rental_duration' => null,
                'rental_type' => null,
                'today_view' => 0,
                'weekly_view' => 0,
                'monthly_view' => 0,
                'total_view' => 1,
                'last_view_reset' => '2025-04-03 18:00:00',
                'last_ep_added' => '2025-04-03 18:00:00',
                'imdbid' => '119051',
                'tmdb_id' => 119051,
                'created_at' => '2025-08-11 08:47:57',
                'updated_at' => '2025-08-11 08:47:57',
            ]
        ];
        DB::table('tv_shows')->insert($tvShows);


        DB::table('live_tvs')->insert([
            [
                'id' => 1,
                'tv_name' => 'channel',
                'slug' => 'channel',
                'description' => '',
                'live_tv_category_id' => 1,
                'country_id' => 14,
                'language' => 'en',
                'stream_from' => 'hls',
                'stream_label' => 'HD',
                'stream_url' => 'http://103.230.105.252:1935/live/btv/manifest.m3u8-48aa-adcf-5a6c64da8c5c_3_playlist.m3u8',
                'thumbnail' => json_encode([
                    "storage" => "local",
                    "original_image" => "https://placehold.co/400x320",
                    "image_240x240" => "https://placehold.co/240x240",
                    "image_80x80" => "https://placehold.co/80x80",
                    "image_1080x720" => "https://placehold.co/1080x1920",
                ]),
                'tags' => '',
                'seo_title' => '',
                'focus_keyword' => '',
                'meta_description' => '',
                'today_view' => 0,
                'weekly_view' => 0,
                'monthly_view' => 0,
                'total_view' => 1,
                'featured' => 1,
                'is_free' => 1,
                'status' => 1,
                'created_at' => '2025-08-11 10:39:29',
                'updated_at' => '2025-08-11 10:54:54',
            ]
        ]);
    }
}
