<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class CountrySeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $countries = [
            ['name' => 'Afghanistan', 'flag' => 'af'],
            ['name' => 'Albania', 'flag' => 'al'],
            ['name' => 'Algeria', 'flag' => 'dz'],
            ['name' => 'Andorra', 'flag' => 'ad'],
            ['name' => 'Angola', 'flag' => 'ao'],
            ['name' => 'Antigua and Barbuda', 'flag' => 'ag'],
            ['name' => 'Argentina', 'flag' => 'ar'],
            ['name' => 'Armenia', 'flag' => 'am'],
            ['name' => 'Australia', 'flag' => 'au'],
            ['name' => 'Austria', 'flag' => 'at'],
            ['name' => 'Azerbaijan', 'flag' => 'az'],
            ['name' => 'Bahamas', 'flag' => 'bs'],
            ['name' => 'Bahrain', 'flag' => 'bh'],
            ['name' => 'Bangladesh', 'flag' => 'bd'],
            ['name' => 'Barbados', 'flag' => 'bb'],
            ['name' => 'Belarus', 'flag' => 'by'],
            ['name' => 'Belgium', 'flag' => 'be'],
            ['name' => 'Belize', 'flag' => 'bz'],
            ['name' => 'Benin', 'flag' => 'bj'],
            ['name' => 'Bhutan', 'flag' => 'bt'],
            ['name' => 'Bolivia', 'flag' => 'bo'],
            ['name' => 'Bosnia and Herzegovina', 'flag' => 'ba'],
            ['name' => 'Botswana', 'flag' => 'bw'],
            ['name' => 'Brazil', 'flag' => 'br'],
            ['name' => 'Brunei', 'flag' => 'bn'],
            ['name' => 'Bulgaria', 'flag' => 'bg'],
            ['name' => 'Burkina Faso', 'flag' => 'bf'],
            ['name' => 'Burundi', 'flag' => 'bi'],
            ['name' => 'Cabo Verde', 'flag' => 'cv'],
            ['name' => 'Cambodia', 'flag' => 'kh'],
            ['name' => 'Cameroon', 'flag' => 'cm'],
            ['name' => 'Canada', 'flag' => 'ca'],
            ['name' => 'Central African Republic', 'flag' => 'cf'],
            ['name' => 'Chad', 'flag' => 'td'],
            ['name' => 'Chile', 'flag' => 'cl'],
            ['name' => 'China', 'flag' => 'cn'],
            ['name' => 'Colombia', 'flag' => 'co'],
            ['name' => 'Comoros', 'flag' => 'km'],
            ['name' => 'Congo', 'flag' => 'cg'],
            ['name' => 'Costa Rica', 'flag' => 'cr'],
            ['name' => 'Croatia', 'flag' => 'hr'],
            ['name' => 'Cuba', 'flag' => 'cu'],
            ['name' => 'Cyprus', 'flag' => 'cy'],
            ['name' => 'Czech Republic', 'flag' => 'cz'],
            ['name' => 'Denmark', 'flag' => 'dk'],
            ['name' => 'Djibouti', 'flag' => 'dj'],
            ['name' => 'Dominica', 'flag' => 'dm'],
            ['name' => 'Dominican Republic', 'flag' => 'do'],
            ['name' => 'Ecuador', 'flag' => 'ec'],
            ['name' => 'Egypt', 'flag' => 'eg'],
            ['name' => 'El Salvador', 'flag' => 'sv'],
            ['name' => 'Equatorial Guinea', 'flag' => 'gq'],
            ['name' => 'Eritrea', 'flag' => 'er'],
            ['name' => 'Estonia', 'flag' => 'ee'],
            ['name' => 'Eswatini', 'flag' => 'sz'],
            ['name' => 'Ethiopia', 'flag' => 'et'],
            ['name' => 'Fiji', 'flag' => 'fj'],
            ['name' => 'Finland', 'flag' => 'fi'],
            ['name' => 'France', 'flag' => 'fr'],
            ['name' => 'Gabon', 'flag' => 'ga'],
            ['name' => 'Gambia', 'flag' => 'gm'],
            ['name' => 'Georgia', 'flag' => 'ge'],
            ['name' => 'Germany', 'flag' => 'de'],
            ['name' => 'Ghana', 'flag' => 'gh'],
            ['name' => 'Greece', 'flag' => 'gr'],
            ['name' => 'Grenada', 'flag' => 'gd'],
            ['name' => 'Guatemala', 'flag' => 'gt'],
            ['name' => 'Guinea', 'flag' => 'gn'],
            ['name' => 'Guinea-Bissau', 'flag' => 'gw'],
            ['name' => 'Guyana', 'flag' => 'gy'],
            ['name' => 'Haiti', 'flag' => 'ht'],
            ['name' => 'Honduras', 'flag' => 'hn'],
            ['name' => 'Hungary', 'flag' => 'hu'],
            ['name' => 'Iceland', 'flag' => 'is'],
            ['name' => 'India', 'flag' => 'in'],
            ['name' => 'Indonesia', 'flag' => 'id'],
            ['name' => 'Iran', 'flag' => 'ir'],
            ['name' => 'Iraq', 'flag' => 'iq'],
            ['name' => 'Ireland', 'flag' => 'ie'],
            ['name' => 'Israel', 'flag' => 'il'],
            ['name' => 'Italy', 'flag' => 'it'],
            ['name' => 'Jamaica', 'flag' => 'jm'],
            ['name' => 'Japan', 'flag' => 'jp'],
            ['name' => 'Jordan', 'flag' => 'jo'],
            ['name' => 'Kazakhstan', 'flag' => 'kz'],
            ['name' => 'Kenya', 'flag' => 'ke'],
            ['name' => 'Kiribati', 'flag' => 'ki'],
            ['name' => 'Korea, North', 'flag' => 'kp'],
            ['name' => 'Korea, South', 'flag' => 'kr'],
            ['name' => 'Kosovo', 'flag' => 'xk'],
            ['name' => 'Kuwait', 'flag' => 'kw'],
            ['name' => 'Kyrgyzstan', 'flag' => 'kg'],
            ['name' => 'Laos', 'flag' => 'la'],
            ['name' => 'Latvia', 'flag' => 'lv'],
            ['name' => 'Lebanon', 'flag' => 'lb'],
            ['name' => 'Lesotho', 'flag' => 'ls'],
            ['name' => 'Liberia', 'flag' => 'lr'],
            ['name' => 'Libya', 'flag' => 'ly'],
            ['name' => 'Liechtenstein', 'flag' => 'li'],
            ['name' => 'Lithuania', 'flag' => 'lt'],
            ['name' => 'Luxembourg', 'flag' => 'lu'],
            ['name' => 'Madagascar', 'flag' => 'mg'],
            ['name' => 'Malawi', 'flag' => 'mw'],
            ['name' => 'Malaysia', 'flag' => 'my'],
            ['name' => 'Maldives', 'flag' => 'mv'],
            ['name' => 'Mali', 'flag' => 'ml'],
            ['name' => 'Malta', 'flag' => 'mt'],
            ['name' => 'Marshall Islands', 'flag' => 'mh'],
            ['name' => 'Mauritania', 'flag' => 'mr'],
            ['name' => 'Mauritius', 'flag' => 'mu'],
            ['name' => 'Mexico', 'flag' => 'mx'],
            ['name' => 'Micronesia', 'flag' => 'fm'],
            ['name' => 'Moldova', 'flag' => 'md'],
            ['name' => 'Monaco', 'flag' => 'mc'],
            ['name' => 'Mongolia', 'flag' => 'mn'],
            ['name' => 'Montenegro', 'flag' => 'me'],
            ['name' => 'Morocco', 'flag' => 'ma'],
            ['name' => 'Mozambique', 'flag' => 'mz'],
            ['name' => 'Myanmar', 'flag' => 'mm'],
            ['name' => 'Namibia', 'flag' => 'na'],
            ['name' => 'Nauru', 'flag' => 'nr'],
            ['name' => 'Nepal', 'flag' => 'np'],
            ['name' => 'Netherlands', 'flag' => 'nl'],
            ['name' => 'New Zealand', 'flag' => 'nz'],
            ['name' => 'Nicaragua', 'flag' => 'ni'],
            ['name' => 'Niger', 'flag' => 'ne'],
            ['name' => 'Nigeria', 'flag' => 'ng'],
            ['name' => 'North Macedonia', 'flag' => 'mk'],
            ['name' => 'Norway', 'flag' => 'no'],
            ['name' => 'Oman', 'flag' => 'om'],
            ['name' => 'Pakistan', 'flag' => 'pk'],
            ['name' => 'Palau', 'flag' => 'pw'],
            ['name' => 'Panama', 'flag' => 'pa'],
            ['name' => 'Papua New Guinea', 'flag' => 'pg'],
            ['name' => 'Paraguay', 'flag' => 'py'],
            ['name' => 'Peru', 'flag' => 'pe'],
            ['name' => 'Philippines', 'flag' => 'ph'],
            ['name' => 'Poland', 'flag' => 'pl'],
            ['name' => 'Portugal', 'flag' => 'pt'],
            ['name' => 'Qatar', 'flag' => 'qa'],
            ['name' => 'Romania', 'flag' => 'ro'],
            ['name' => 'Russia', 'flag' => 'ru'],
            ['name' => 'Rwanda', 'flag' => 'rw'],
            ['name' => 'Saint Kitts and Nevis', 'flag' => 'kn'],
            ['name' => 'Saint Lucia', 'flag' => 'lc'],
            ['name' => 'Saint Vincent and the Grenadines', 'flag' => 'vc'],
            ['name' => 'Samoa', 'flag' => 'ws'],
            ['name' => 'San Marino', 'flag' => 'sm'],
            ['name' => 'Sao Tome and Principe', 'flag' => 'st'],
            ['name' => 'Saudi Arabia', 'flag' => 'sa'],
            ['name' => 'Senegal', 'flag' => 'sn'],
            ['name' => 'Serbia', 'flag' => 'rs'],
            ['name' => 'Seychelles', 'flag' => 'sc'],
            ['name' => 'Sierra Leone', 'flag' => 'sl'],
            ['name' => 'Singapore', 'flag' => 'sg'],
            ['name' => 'Slovakia', 'flag' => 'sk'],
            ['name' => 'Slovenia', 'flag' => 'si'],
            ['name' => 'Solomon Islands', 'flag' => 'sb'],
            ['name' => 'Somalia', 'flag' => 'so'],
            ['name' => 'South Africa', 'flag' => 'za'],
            ['name' => 'South Sudan', 'flag' => 'ss'],
            ['name' => 'Spain', 'flag' => 'es'],
            ['name' => 'Sri Lanka', 'flag' => 'lk'],
            ['name' => 'Sudan', 'flag' => 'sd'],
            ['name' => 'Suriname', 'flag' => 'sr'],
            ['name' => 'Sweden', 'flag' => 'se'],
            ['name' => 'Switzerland', 'flag' => 'ch'],
            ['name' => 'Syria', 'flag' => 'sy'],
            ['name' => 'Taiwan', 'flag' => 'tw'],
            ['name' => 'Tajikistan', 'flag' => 'tj'],
            ['name' => 'Tanzania', 'flag' => 'tz'],
            ['name' => 'Thailand', 'flag' => 'th'],
            ['name' => 'Togo', 'flag' => 'tg'],
            ['name' => 'Tonga', 'flag' => 'to'],
            ['name' => 'Trinidad and Tobago', 'flag' => 'tt'],
            ['name' => 'Tunisia', 'flag' => 'tn'],
            ['name' => 'Turkey', 'flag' => 'tr'],
            ['name' => 'Turkmenistan', 'flag' => 'tm'],
            ['name' => 'Tuvalu', 'flag' => 'tv'],
            ['name' => 'Uganda', 'flag' => 'ug'],
            ['name' => 'Ukraine', 'flag' => 'ua'],
            ['name' => 'United Arab Emirates', 'flag' => 'ae'],
            ['name' => 'United Kingdom', 'flag' => 'gb'],
            ['name' => 'United States', 'flag' => 'us'],
            ['name' => 'Uruguay', 'flag' => 'uy'],
            ['name' => 'Uzbekistan', 'flag' => 'uz'],
            ['name' => 'Vanuatu', 'flag' => 'vu'],
            ['name' => 'Vatican City', 'flag' => 'va'],
            ['name' => 'Venezuela', 'flag' => 've'],
            ['name' => 'Vietnam', 'flag' => 'vn'],
            ['name' => 'Yemen', 'flag' => 'ye'],
            ['name' => 'Zambia', 'flag' => 'zm'],
            ['name' => 'Zimbabwe', 'flag' => 'zw'],
        ];

        foreach ($countries as $country) {
            DB::table('countries')->insert([
                'name' => $country['name'],
                'slug' => Str::slug($country['name']),
                'description' => null,
                'flag' => $country['flag'],
                'status' => 1,
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }
    }
}