<?php

use App\Models\Role;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('roles', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('slug')->nullable();
            $table->text('permissions')->nullable();
            $table->tinyInteger('status')->default(1)->comment('0 inactive, 1 active');
            $table->timestamps();
        });
        $now = now();
        Role::create([
            'name' => 'Admin',
            'slug' => 'admin',
            'permissions' => [
                "admin.dashboard",
                "email.server-configuration",
                "email.server-configuration.update",
                "email.test",
                "email.template",
                "email.template.update",
                "admin.movies",
                "admin.movie.add",
                "admin.movie.store",
                "admin.movie.delete",
                "admin.movie.edit",
                "admin.movie.update",
                "admin.movie.upload.downloads",
                "admin.movie.file.add",
                "admin.movie.file.store",
                "admin.movie.file.delete",
                "admin.movie.file.edit",
                "admin.movie.file.update",
                "admin.make.rental",
                "admin.make.rent.store",
                "admin.download.links",
                "admin.download.link.add",
                "admin.download_link.store",
                "admin.download_link.edit",
                "admin.download_link.update",
                "admin.download_link.delete",
                "admin.download_link.status",
                "admin.categories",
                "admin.category.add",
                "admin.category.store",
                "admin.category.delete",
                "admin.category.edit",
                "admin.category.update",
                "admin.category.primary.status",
                "admin.category.footer.status",
                "admin.tv.shows",
                "admin.tv.show.add",
                "admin.tv.show.store",
                "admin.tv.show.delete",
                "admin.tv.show.edit",
                "admin.tv.show.update",
                "admin.tv.show.settings",
                "admin.tv.show.config",
                "admin.live.tv.categories",
                "admin.live.tv.category.add",
                "admin.live.tv.category.store",
                "admin.live.tv.category.delete",
                "admin.live.tv.category.edit",
                "admin.live.tv.category.update",
                "admin.live.tv.category.status",
                "admin.live.tvs",
                "admin.live.tv.add",
                "admin.live.tv.store",
                "admin.live.tv.delete",
                "admin.live.tv.edit",
                "admin.live.tv.update",
                "admin.live.tv.status",
                "admin.live.tv.feature",
                "admin.seasons",
                "admin.season.add",
                "admin.season.store",
                "admin.season.delete",
                "admin.season.edit",
                "admin.season.update",
                "admin.episodes",
                "admin.episode.add",
                "admin.episode.store",
                "admin.episode.delete",
                "admin.episode.edit",
                "admin.episode.update",
                "admin.stars",
                "admin.star.add",
                "admin.star.store",
                "admin.star.delete",
                "admin.star.edit",
                "admin.star.update",
                "admin.star.status",
                "admin.languages",
                "admin.language.add",
                "admin.language.store",
                "admin.language.delete",
                "admin.language.edit",
                "admin.language.update",
                "admin.language.status",
                "admin.language.translations.page",
                "admin.language.key.update",
                "admin.countries",
                "admin.country.add",
                "admin.country.store",
                "admin.country.delete",
                "admin.country.edit",
                "admin.country.update",
                "admin.country.status",
                "admin.staffs",
                "admin.staff.add",
                "admin.staff.store",
                "admin.staff.delete",
                "admin.staff.edit",
                "admin.staff.update",
                "admin.staff.status",
                "roles.index",
                "roles.create",
                "roles.edit",
                "roles.update",
                "roles.destroy",
                "admin.subscribers",
                "admin.subscriber.add",
                "admin.subscriber.store",
                "admin.subscriber.delete",
                "admin.subscriber.edit",
                "admin.subscriber.update",
                "admin.subscriber.status",
                "admin.packages",
                "admin.package.add",
                "admin.package.store",
                "admin.package.delete",
                "admin.package.edit",
                "admin.package.update",
                "admin.package.status",
                "admin.video.qualities",
                "admin.video.quality.add",
                "admin.video.quality.store",
                "admin.video.quality.delete",
                "admin.video.quality.edit",
                "admin.video.quality.update",
                "admin.video.quality.status",
                "admin.importer",
                "admin.fetch.movies",
                "admin.import.db",
                "admin.interest",
                "admin.interest.add",
                "admin.interest.store",
                "admin.interest.delete",
                "admin.interest.edit",
                "admin.interest.update",
                "admin.interest.status",
                "admin.system.settings",
                "admin.settings",
                "admin.tmdb.settings",
                "admin.social.settings",
                "admin.recaptcha.settings",
                "admin.setting.update",
                "setting.status.change",
                "admin.sms-gateway-settings",
                "admin.blog.categories",
                "admin.blog.category.add",
                "admin.blog.category.store",
                "admin.blog.category.delete",
                "admin.blog.category.edit",
                "admin.blog.category.update",
                "admin.blog.category.status",
                "admin.blogs",
                "admin.blog.add",
                "admin.blog.store",
                "admin.blog.delete",
                "admin.blog.edit",
                "admin.blog.update",
                "admin.blog.status",
                "admin.faqs",
                "admin.faq.add",
                "admin.faq.store",
                "admin.faq.delete",
                "admin.faq.edit",
                "admin.faq.update",
                "admin.faq.status",
                "pages.index",
                "pages.create",
                "pages.store",
                "pages.edit",
                "pages.update",
                "page.delete",
                "page.status.change",
                "admin.ads",
                "admin.ads.delete",
                "admin.ads.edit",
                "admin.ads.update",
                "admin.ads.status",
                "admin.ads.pre_roll.index",
                "admin.ads.pre_roll.add",
                "admin.ads.pre_roll.edit",
                "admin.ads.pre_roll.update",
                "admin.ads.pre_roll.store",
                "admin.ads.mid_roll.index",
                "admin.ads.mid_roll.add",
                "admin.ads.mid_roll.edit",
                "admin.ads.mid_roll.update",
                "admin.ads.mid_roll.store",
                "admin.ads.post_roll.index",
                "admin.ads.post_roll.add",
                "admin.ads.post_roll.edit",
                "admin.ads.post_roll.update",
                "admin.ads.post_roll.store",
                "admin.manage.profile",
                "admin.update.profile",
                "admin.change.password",
                "admin.password.update",
                "payment.gateways",
                "payment.gateway",
                "all.subscription",
                "transaction.log",
                "rental.history",
                "subscribe-list.status",
                "admin.add.subscription",
                "create.subscription",
                "rent-list.status",
                "stop.recurring",
                "admin.theme.options",
                "admin.theme.options.post",
                "website.seo",
                "server.info",
                "system.info",
                "extension.library",
                "file.system.permission",
                "system.update",
                "download.system.update",
                "footer.content",
                "footer.primary-content",
                "footer.primary-content",
                "footer.payment-banner-settings",
                "footer.copyright",
                "footer.update-setting",
                "footer.update-menu",
                "footer.social-link",
                "footer.app_links",
                "footer.legal_pages_link_setting",
                "footer.help_center_link_setting",
                "admin.movie_requests",
                "admin.movie_request.delete",
                "admin.movie_request.update",
                "admin.reports",
                "admin.report.delete",
                "admin.report.update"
            ],
        ]);
        $data = [
            [
                'name' => 'Staff',
                'slug' => 'staff',
                'created_at' => $now,
                'updated_at' => $now,
                'permissions' => json_encode([
                    "admin.dashboard",
                    "email.server-configuration",
                    "email.server-configuration.update",
                    "email.test",
                    "email.template",
                    "email.template.update",
                    "admin.movies",
                    "admin.movie.add",
                    "admin.movie.store",
                    "admin.movie.delete",
                    "admin.movie.edit",
                    "admin.movie.update",
                    "admin.movie.upload.downloads",
                    "admin.movie.file.add",
                    "admin.movie.file.store",
                    "admin.movie.file.delete",
                    "admin.movie.file.edit",
                    "admin.movie.file.update",
                    "admin.make.rental",
                    "admin.make.rent.store",
                    "admin.download.links",
                    "admin.download.link.add",
                    "admin.download_link.store",
                    "admin.download_link.edit",
                    "admin.download_link.update",
                    "admin.download_link.delete",
                    "admin.download_link.status",
                    "admin.categories",
                    "admin.category.add",
                    "admin.category.store",
                    "admin.category.delete",
                    "admin.category.edit",
                    "admin.category.update",
                    "admin.category.primary.status",
                    "admin.category.footer.status",
                    "admin.tv.shows",
                    "admin.tv.show.add",
                    "admin.tv.show.store",
                    "admin.tv.show.delete",
                    "admin.tv.show.edit",
                    "admin.tv.show.update",
                    "admin.tv.show.settings",
                    "admin.tv.show.config",
                    "admin.live.tv.categories",
                    "admin.live.tv.category.add",
                    "admin.live.tv.category.store",
                    "admin.live.tv.category.delete",
                    "admin.live.tv.category.edit",
                    "admin.live.tv.category.update",
                    "admin.live.tv.category.status",
                    "admin.live.tvs",
                    "admin.live.tv.add",
                    "admin.live.tv.store",
                    "admin.live.tv.delete",
                    "admin.live.tv.edit",
                    "admin.live.tv.update",
                    "admin.live.tv.status",
                    "admin.live.tv.feature",
                    "admin.seasons",
                    "admin.season.add",
                    "admin.season.store",
                    "admin.season.delete",
                    "admin.season.edit",
                    "admin.season.update",
                    "admin.episodes",
                    "admin.episode.add",
                    "admin.episode.store",
                    "admin.episode.delete",
                    "admin.episode.edit",
                    "admin.episode.update",
                    "admin.stars",
                    "admin.star.add",
                    "admin.star.store",
                    "admin.star.delete",
                    "admin.star.edit",
                    "admin.star.update",
                    "admin.star.status",
                    "admin.languages",
                    "admin.language.add",
                    "admin.language.store",
                    "admin.language.delete",
                    "admin.language.edit",
                    "admin.language.update",
                    "admin.language.status",
                    "admin.language.translations.page",
                    "admin.language.key.update",
                    "admin.countries",
                    "admin.country.add",
                    "admin.country.store",
                    "admin.country.delete",
                    "admin.country.edit",
                    "admin.country.update",
                    "admin.country.status",
                    "admin.staffs",
                    "admin.staff.add",
                    "admin.staff.store",
                    "admin.staff.delete",
                    "admin.staff.edit",
                    "admin.staff.update",
                    "admin.staff.status",
                    "roles.index",
                    "roles.create",
                    "roles.edit",
                    "roles.update",
                    "roles.destroy",
                    "admin.subscribers",
                    "admin.subscriber.add",
                    "admin.subscriber.store",
                    "admin.subscriber.delete",
                    "admin.subscriber.edit",
                    "admin.subscriber.update",
                    "admin.subscriber.status",
                    "admin.packages",
                    "admin.package.add",
                    "admin.package.store",
                    "admin.package.delete",
                    "admin.package.edit",
                    "admin.package.update",
                    "admin.package.status",
                    "admin.video.qualities",
                    "admin.video.quality.add",
                    "admin.video.quality.store",
                    "admin.video.quality.delete",
                    "admin.video.quality.edit",
                    "admin.video.quality.update",
                    "admin.video.quality.status",
                    "admin.importer",
                    "admin.fetch.movies",
                    "admin.import.db",
                    "admin.interest",
                    "admin.interest.add",
                    "admin.interest.store",
                    "admin.interest.delete",
                    "admin.interest.edit",
                    "admin.interest.update",
                    "admin.interest.status",
                    "admin.system.settings",
                    "admin.settings",
                    "admin.tmdb.settings",
                    "admin.social.settings",
                    "admin.recaptcha.settings",
                    "admin.setting.update",
                    "setting.status.change",
                    "admin.sms-gateway-settings",
                    "admin.blog.categories",
                    "admin.blog.category.add",
                    "admin.blog.category.store",
                    "admin.blog.category.delete",
                    "admin.blog.category.edit",
                    "admin.blog.category.update",
                    "admin.blog.category.status",
                    "admin.blogs",
                    "admin.blog.add",
                    "admin.blog.store",
                    "admin.blog.delete",
                    "admin.blog.edit",
                    "admin.blog.update",
                    "admin.blog.status",
                    "admin.faqs",
                    "admin.faq.add",
                    "admin.faq.store",
                    "admin.faq.delete",
                    "admin.faq.edit",
                    "admin.faq.update",
                    "admin.faq.status",
                    "pages.index",
                    "pages.create",
                    "pages.store",
                    "pages.edit",
                    "pages.update",
                    "page.delete",
                    "page.status.change",
                    "admin.ads",
                    "admin.ads.delete",
                    "admin.ads.edit",
                    "admin.ads.update",
                    "admin.ads.status",
                    "admin.ads.pre_roll.index",
                    "admin.ads.pre_roll.add",
                    "admin.ads.pre_roll.edit",
                    "admin.ads.pre_roll.update",
                    "admin.ads.pre_roll.store",
                    "admin.ads.mid_roll.index",
                    "admin.ads.mid_roll.add",
                    "admin.ads.mid_roll.edit",
                    "admin.ads.mid_roll.update",
                    "admin.ads.mid_roll.store",
                    "admin.ads.post_roll.index",
                    "admin.ads.post_roll.add",
                    "admin.ads.post_roll.edit",
                    "admin.ads.post_roll.update",
                    "admin.ads.post_roll.store",
                    "admin.manage.profile",
                    "admin.update.profile",
                    "admin.change.password",
                    "admin.password.update",
                    "payment.gateways",
                    "payment.gateway",
                    "all.subscription",
                    "transaction.log",
                    "rental.history",
                    "subscribe-list.status",
                    "admin.add.subscription",
                    "create.subscription",
                    "rent-list.status",
                    "stop.recurring",
                    "admin.theme.options",
                    "admin.theme.options.post",
                    "website.seo",
                    "server.info",
                    "system.info",
                    "extension.library",
                    "file.system.permission",
                    "system.update",
                    "download.system.update",
                    "footer.content",
                    "footer.primary-content",
                    "footer.primary-content",
                    "footer.payment-banner-settings",
                    "footer.copyright",
                    "footer.update-setting",
                    "footer.update-menu",
                    "footer.social-link",
                    "footer.app_links",
                    "footer.legal_pages_link_setting",
                    "footer.help_center_link_setting",
                    "admin.movie_requests",
                    "admin.movie_request.delete",
                    "admin.movie_request.update",
                    "admin.reports",
                    "admin.report.delete",
                    "admin.report.update"
                ]),
            ]
        ];
        Role::insert($data);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('roles');
    }
};
