<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('download_links', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->text('link');
            $table->string('resolution', 50)->default('720p');
            $table->string('file_size', 50)->default('00MB');
            $table->integer('status')->default(1);
            $table->morphs('downloadable'); // creates `downloadable_id` and `downloadable_type`

            $table->timestamps();

        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('download_links');
    }
};
