<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('blogs', function (Blueprint $table) {
            $table->id();
            $table->string('title', 191);
            $table->string('slug', 191);
            $table->longText('description')->nullable();
            $table->unsignedBigInteger('category_id');;
            $table->longText('image')->nullable();
            $table->string('seo_title', 191)->nullable();
            $table->string('meta_description', 191)->nullable();
            $table->string('focus_keyword', 191)->nullable();
            $table->string('tags', 191)->nullable();
            $table->integer('status')->default(0);
            $table->integer('is_top')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('blogs');
    }
};
