<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('live_tvs', function (Blueprint $table) {
            $table->id();
            $table->string('tv_name', 191)->nullable();
            $table->string('slug')->nullable();
            $table->longText('description')->nullable();
            $table->integer('live_tv_category_id')->nullable();
            $table->integer('country_id')->nullable();

            $table->string('language', 10)->nullable()->default('en');

            $table->string('stream_from', 191)->nullable();
            $table->string('stream_label', 191)->nullable();
            $table->string('stream_url', 191)->nullable();

            $table->longText('thumbnail')->nullable();

            $table->longText('tags')->nullable();
            $table->string('seo_title', 191)->nullable();
            $table->longText('focus_keyword')->nullable();
            $table->longText('meta_description')->nullable();

            $table->integer('today_view')->unsigned()->default(0);
            $table->integer('weekly_view')->unsigned()->default(0);
            $table->mediumInteger('monthly_view')->unsigned()->default(0);
            $table->bigInteger('total_view')->unsigned()->default(1);

            $table->integer('featured')->nullable()->default(1);
            $table->integer('is_free')->default(1);
            $table->tinyInteger('status')->default(1);

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('live_tvs');
    }
};
