<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('movie_files', function (Blueprint $table) {
            $table->id();
            $table->string('stream_key',50)->nullable();
            $table->bigInteger('video_id')->nullable();
            $table->string('file_source',191)->nullable();
            $table->string('source_type',191)->nullable();
            $table->string('file_url',191)->nullable();
            $table->string('label',191)->default('Server#1');
            $table->integer('order')->default(0);
            $table->string('conversion_status')->default('pending');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('movie_files');
    }
};
