<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tv_shows', function (Blueprint $table) {
            $table->id();
            $table->text('title')->nullable();
            $table->text('thumbnail')->nullable();
            $table->text('poster')->nullable();
            $table->string('slug', 191)->nullable();
            $table->string('seo_title', 191)->nullable();
            $table->longText('description')->nullable();
            $table->text('stars')->nullable();
            $table->text('director')->nullable();
            $table->text('writer')->nullable();
            $table->string('rating', 5)->nullable()->default(0);
            $table->string('release', 25)->nullable();
            $table->string('country', 191)->nullable();
            $table->string('genre', 191)->nullable();
            $table->string('language')->nullable();
            $table->string('video_type', 50)->nullable();
            $table->string('runtime', 10)->nullable();
            $table->string('video_quality', 191)->nullable()->default('HD');
            $table->tinyInteger('is_original')->default(0);
            $table->tinyInteger('is_featured')->default(0);
            $table->tinyInteger('is_blockbuster')->default(0);
            $table->tinyInteger('is_recommended')->default(0);
            $table->tinyInteger('is_real_life_story')->default(0);
            $table->tinyInteger('status')->default(1);
            $table->tinyInteger('trailer')->nullable()->default(0);
            $table->mediumText('trailler_youtube_source')->nullable();
            $table->tinyInteger('enable_download')->nullable()->default(1);
            $table->mediumText('focus_keyword')->nullable();
            $table->mediumText('meta_description')->nullable();
            $table->mediumText('tags')->nullable();
            $table->string('imdb_rating', 5)->nullable();
            $table->tinyInteger('is_tvseries')->default(0);
            $table->tinyInteger('is_popular')->nullable()->default(0);
            $table->integer('total_rating')->nullable()->default(1);

           $table->integer('is_free')->default(0);
            $table->integer('is_rental')->default(0);
            $table->integer('rental_price')->nullable();
            $table->integer('rental_duration')->nullable();
            $table->string('rental_type')->nullable();

            $table->integer('today_view')->unsigned()->default(0);
            $table->integer('weekly_view')->unsigned()->default(0);
            $table->mediumInteger('monthly_view')->unsigned()->default(0);
            $table->bigInteger('total_view')->unsigned()->default(1);
            $table->timestamp('last_view_reset')->nullable()->default('2025-04-04 00:00:00');

            $table->timestamp('last_ep_added')->nullable()->default('2025-04-04 00:00:00');
            $table->string('imdbid')->nullable();
            $table->bigInteger('tmdb_id')->unsigned()->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tv_shows');
    }
};
