<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('stars', function (Blueprint $table) {
            $table->id();
            $table->string('star_name', 191)->nullable();
            $table->string('slug', 191)->nullable();
            $table->string('star_type', 191)->nullable();
            $table->unsignedBigInteger('country_id')->nullable();
            $table->foreign('country_id')->references('id')->on('countries')->onDelete('set null');
            $table->date('star_dob')->nullable();
            $table->string('ranking', 191)->nullable();
            $table->string('gender', 191)->nullable();
            $table->text('industries')->nullable();
            $table->mediumText('star_image')->nullable();
            $table->mediumText('star_desc')->nullable();
            $table->integer('view')->default(1);
            $table->tinyInteger('status')->default(1);
             $table->string('facebook', 191)->nullable();
             $table->string('twitter', 191)->nullable();
             $table->string('instagram', 191)->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('stars');
    }
};
