<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('categories', function (Blueprint $table) {
            $table->id();
            $table->string('video_type');
            $table->text('video_type_desc')->nullable();
            $table->tinyInteger('primary_menu')->default(0);
            $table->tinyInteger('footer_menu')->default(0);
            $table->tinyInteger('thumbnail_style')->default(1);
            $table->tinyInteger('order')->default(1);
            $table->string('slug',100);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('categories');
    }
};
