<?php

namespace App\Traits\Mobile;

trait ApiResponseTrait
{
    protected function responseWithSuccess($data = Null, $message = Null)
    {
        // if (!$data) {
        //     return $this->responseWithError('data_not_exist', 400);
        // }
        $response = [
            'code'      => 200,
            'status'    => 'success',
            'message'   => $message,
            'data'      => $data
        ];
        return response()->json($response, 200);

    }

    protected function responseWithError($message = Null, $code = Null)
    {
        $response = [
            'code'      => $code,
            'status'    => 'error',
            'message'   => $message,
            'data'   => []
        ];
        return response()->json($response, $code);

    }
    protected function responseWithValidation($errors, $code = 422, $message = 'Required field missing',)
    {
        $response = [
            'code' => $code,
            'status' => 'error',
            'message' => $message,
            'data'    => $errors,
        ];

        return response()->json($response, $code);
    }

}
