<?php

namespace App\Traits;

use App\Models\WatchHistory;

trait HasWatchHistory
{
    public function watchHistory()
    {
        return $this->morphMany(WatchHistory::class, 'watchable');
    }

    public function getWatchHistoryForUser($userId)
    {
        return $this->watchHistory()->where('user_id', $userId)->first();
    }
}
