<?php

namespace App\Repositories\Admin;

use App\Models\Star;
use App\Repositories\Interfaces\Admin\StarInterface;
use Carbon\Carbon;
use App\Traits\ImageTrait;
use Illuminate\Support\Str;
use Illuminate\Http\UploadedFile;

class StarRepository implements StarInterface
{
    use ImageTrait;

    public function all()
    {
        return Star::get();
    }

    public function store($request)
    {
        try {
            if (isset($request['star_image']) && $request['star_image'] instanceof UploadedFile) {
                $requestImage = $request['star_image'];
                $response = $this->saveImage($requestImage, '_star_');
                $request['star_image'] = $response['images'];
            }
            $data = [
                'star_name' => $request['star_name'],
                'star_type' => $request['star_type'],
                'star_desc' => $request['star_desc'],
                'country_id' => $request['country_id'],
                'star_dob' => $request['star_dob'],
                'ranking' => $request['ranking'],
                'gender' => $request['gender'],
                'facebook' => $request['facebook'],
                'twitter' => $request['twitter'],
                'instagram' => $request['instagram'],
                'industries' => $request['industries'] ? json_encode($request['industries']) : '',
                'star_image' => isset($request['star_image']) ? json_encode($request['star_image']) : '',
                'slug' => Str::slug($request['star_name']),
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ];
            return Star::create($data);
        } catch (\Exception $e) {
            throw $e;
        }
    }

    public function update($request, $id)
    {
        try {
            $star = Star::where('id', $id)->first();
            if (isset($request['star_image']) && $request['star_image'] instanceof UploadedFile) {
                $requestImage = $request['star_image'];
                $this->imageDelete($id, 'star', 'star_image');
                $response = $this->saveImage($requestImage, '_star_');
                $request['star_image'] = $response['images'];
            }
            $data = [
                'star_name' => $request['star_name'],
                'star_type' => $request['star_type'],
                'star_desc' => $request['star_desc'],
                'country_id' => $request['country_id'],
                'star_dob' => $request['star_dob'],
                'ranking' => $request['ranking'],
                'gender' => $request['gender'],
                'facebook' => $request['facebook'],
                'twitter' => $request['twitter'],
                'instagram' => $request['instagram'],
                'industries' => json_encode($request['industries']),
                'star_image' => isset($request['star_image']) ? json_encode($request['star_image']) : $star->star_image,
                'slug' => Str::slug($request['star_name']),
                'updated_at' => Carbon::now(),
            ];
            return Star::where('id', $id)->update($data);
        } catch (\Exception $e) {
            throw $e;
        }
    }
}