<?php
namespace App\Repositories\Admin;

use App\Models\Report;
use App\Repositories\Interfaces\Admin\ReportInterface;

class ReportRepository implements ReportInterface
{
    public function all()
    {
        return Report::latest()->get();
    }

    public function find($id)
    {
        return Report::findOrFail($id);
    }

    public function create(array $data)
    {
        return Report::create([
            'user_id' => auth()->user()->id ?? null,
            'reportable_type' => $data['reportable_type'] ?? null,
            'reportable_id' => $data['reportable_id'] ?? null,
            'video_issue' => $data['video_issue'] ?? null,
            'audio_issue' => $data['audio_issue'] ?? null,
            'subtitle_issue' => $data['subtitle_issue'] ?? null,
            'message' => $data['message'] ?? null,
            'status' => 'pending',
        ]);
    }


    public function update($id, array $data)
    {
        $report = $this->find($id);
        $report->update($data);
        return $report;
    }

    public function delete($id)
    {
        return Report::destroy($id);
    }
}