<?php

namespace App\Repositories\Admin;

use App\Models\MovieIndustry;
use App\Models\Star;
use App\Repositories\Interfaces\Admin\MovieIndustryInterface;
use App\Traits\ImageTrait;

class MovieIndustryRepository implements MovieIndustryInterface
{
    use ImageTrait;

    public function store($request)
    {
        try {
            return MovieIndustry::create([
                'name' => $request['name'],
                'status' => $request['status'],
                'country_id' => $request['country_id'],
            ]);
        } catch (\Exception $e) {
            throw $e;
        }
    }

    public function update($request, $id)
    {
        try {
            return MovieIndustry::where('id', $id)->update([
                'name' => $request['name'],
                'status' => $request['status'],
                'country_id' => $request['country_id'],
            ]);
        } catch (\Exception $e) {
            throw $e;
        }
    }
}