<?php

namespace App\Repositories\Admin;

use App\Models\Channel;
use App\Models\LiveTv;
use App\Models\LiveTvUrl;
use App\Repositories\Interfaces\Admin\ChannelInterface;
use App\Repositories\Interfaces\Admin\LiveTvInterface;
use App\Traits\ImageTrait;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use Illuminate\Http\UploadedFile;

class LiveTvRepository implements LiveTvInterface
{
    use ImageTrait;

    public function all()
    {
        return LiveTv::get();
    }

    public function get($id)
    {
        return LiveTv::findOrFail($id);
    }

    public function store($request)
    {
        DB::beginTransaction();
        try {

            $livetv = new LiveTv();
            if (isset($request['thumbnail']) && $request['thumbnail']) {
                $requestImage = $request['thumbnail'];
                $response = $this->saveImage($requestImage, '_live_tv_thumb_');
                $livetv->thumbnail = json_encode($response['images']);
            }

            $livetv->tv_name = $request['tv_name'];
            $livetv->live_tv_category_id = $request['category'];
            $livetv->country_id = $request['country_id'];

            $livetv->slug = Str::slug($request['tv_name']);
            $livetv->description = $request['description'];
            $livetv->stream_from = $request['stream_from'];
            $livetv->stream_label = $request['stream_label'];
            $livetv->stream_url = $request['stream_url'];

            $livetv->featured = $request['featured'];
            $livetv->seo_title = $request['seo_title'];
            $livetv->focus_keyword = $request['focus_keyword'];
            $livetv->meta_description = $request['meta_description'];
            $livetv->tags = $request['tags'];
            $livetv->status = $request['status'] ? 1 : 0;
            $livetv->save();

            if ($request['stream_url1'] != ''):
                $livetvurl = new LiveTvUrl();
                $livetvurl->stream_key = Str::random(32);
                ;
                $livetvurl->live_tv_id = $livetv->id;
                $livetvurl->source = $request['stream_from1'];
                $livetvurl->label = $request['stream_label1'];
                $livetvurl->quality = $request['stream_label1'];
                $livetvurl->url_for = 'op1';
                $livetvurl->url = $request['stream_url1'];
                $livetvurl->save();

            endif;
            if ($request['stream_url2'] != ''):
                $livetvurl = new LiveTvUrl();
                $livetvurl->stream_key = Str::random(32);
                ;
                $livetvurl->live_tv_id = $livetv->id;
                $livetvurl->source = $request['stream_from2'];
                $livetvurl->label = $request['stream_label2'];
                $livetvurl->quality = $request['stream_label2'];
                $livetvurl->url_for = 'op2';
                $livetvurl->url = $request['stream_url2'];

                $livetvurl->save();
            endif;

            DB::commit();

            return true;

        } catch (\Exception $e) {
            DB::rollback();
            throw $e;
        }
    }

    public function update($request, $id)
    {

        // dd($request);

        DB::beginTransaction();
        try {
            $livetv = $this->get($id);
            if (isset($request['thumbnail']) && $request['thumbnail']) {
                $requestImage = $request['thumbnail'];
                
                $this->imageDelete($id, 'liveTv', 'thumbnail');
                $response = $this->saveImage($requestImage, '_live_tv_thumb_');
                $livetv->thumbnail = json_encode($response['images']);
            }


            $livetv->country_id = $request['country_id'];
            $livetv->tv_name = $request['tv_name'];
            $livetv->live_tv_category_id = $request['category'];
            $livetv->slug = Str::slug($request['tv_name']);
            $livetv->description = $request['description'];
            $livetv->stream_from = $request['stream_from'];
            $livetv->stream_label = $request['stream_label'];
            $livetv->stream_url = $request['stream_url'];

            $livetv->featured = $request['featured'];
            $livetv->seo_title = $request['seo_title'];
            $livetv->focus_keyword = $request['focus_keyword'];
            $livetv->meta_description = $request['meta_description'];
            $livetv->tags = $request['tags'];
            $livetv->status = $request['status'] ? 1 : 0;
            $livetv->save();

            if ($request['stream_url1'] != ''):
                $livetvurl1 = '';
                if ($request['op1_id'] != ''):
                    $livetvurl1 = LiveTvUrl::find($request['op1_id']);
                endif;

                if (blank($livetvurl1) || $livetvurl1 == '' || $request['op1_id'] == null):
                    $livetvurl1 = new LiveTvUrl();
                endif;

                $livetvurl1->stream_key = Str::random(32);
                ;
                $livetvurl1->live_tv_id = $livetv->id;
                $livetvurl1->source = $request['stream_from1'];
                $livetvurl1->label = $request['stream_label1'];
                $livetvurl1->quality = $request['stream_label1'];
                $livetvurl1->url_for = 'op1';
                $livetvurl1->url = $request['stream_url1'];
                $livetvurl1->save();

            endif;

            if ($request['stream_url2'] != ''):
                $livetvurl2 = '';
                if ($request['op2_id'] != ''):
                    $livetvurl2 = LiveTvUrl::find($request['op2_id']);
                endif;

                if (blank($livetvurl2) || $livetvurl2 == '' || $request['op2_id'] == null):
                    $livetvurl2 = new LiveTvUrl();
                endif;

                $livetvurl2->stream_key = Str::random(32);
                ;
                $livetvurl2->live_tv_id = $livetv->id;
                $livetvurl2->source = $request['stream_from2'];
                $livetvurl2->label = $request['stream_label2'];
                $livetvurl2->quality = $request['stream_label2'];
                $livetvurl2->url_for = 'op2';
                $livetvurl2->url = $request['stream_url2'];

                $livetvurl2->save();
            endif;

            DB::commit();
            return true;

        } catch (\Exception $e) {
            dd($e);
            DB::rollback();
            return false;
        }
    }
}