<?php

namespace App\Repositories\Admin;

use App\Models\LiveTvCategory;
use App\Models\MovieLanguage;
use App\Repositories\Interfaces\Admin\LiveTvCategoryInterface;
use Carbon\Carbon;
use Illuminate\Support\Str;

class LiveTvCategoryRepository implements LiveTvCategoryInterface
{
    public function all()
    {
        return LiveTvCategory::get();
    }

    public function store($request) {
        try {
            $data = [
                'live_tv_category' => $request['name'],
                'live_tv_category_desc' => $request['description'],
                'status' => $request['status'],
                'slug' => Str::slug($request['name']),
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ];
            return LiveTvCategory::create($data);
        } catch (\Exception $e) {
            return false;
        }
    }

    public function update($request, $id) {
        try {
            $data = [
                'live_tv_category' => $request['name'],
                'live_tv_category_desc' => $request['description'],
                'status' => $request['status'],
                'slug' => Str::slug($request['name']),
                'updated_at' => Carbon::now(),
            ];
            return LiveTvCategory::where('id', $id)->update($data);
        } catch (\Exception $e) {
            return false;
        }
    }
}