<?php

namespace App\Repositories\Admin;

use App\Models\Interest;
use App\Repositories\Interfaces\Admin\InterestInterface;
use Carbon\Carbon;
use App\Traits\ImageTrait;

class InterestRepository implements InterestInterface
{
    use ImageTrait;

    public function all()
    {
        return Interest::get();
    }

    public function store($request) {
        try {
            $data = [
                'title' => $request['title'],
                'status' => $request['status'],
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ];
            return Interest::create($data);
        } catch (\Exception $e) {
            return false;
        }
    }

    public function update($request, $id) {
        try {
            $data = [
                'title' => $request['title'],
                'status' => $request['status'],
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ];
            return Interest::where('id', $id)->update($data);
        } catch (\Exception $e) {
            return false;
        }
    }
}