<?php

namespace App\Repositories\Admin;

use App\Models\Faq;
use App\Repositories\Interfaces\Admin\FaqInterface;
use App\Repositories\Interfaces\Admin\GenreInterface;
use Carbon\Carbon;
use App\Traits\ImageTrait;
use Illuminate\Http\UploadedFile;
use Illuminate\Support\Str;

class FaqRepository implements FaqInterface
{
    use ImageTrait;

    public function all()
    {
        return Faq::get();
    }

    public function store($request) {
        try {
            $data = [
                'question' => $request['question'],
                'answer' => $request['answer'],
                'status' => $request['status'],
                'type' => $request['type'],
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ];
            return Faq::create($data);
        } catch (\Exception $e) {
            return false;
        }
    }

    public function update($request, $id) {
        try {
            $data = [
                'question' => $request['question'],
                'answer' => $request['answer'],
                'status' => $request['status'],
                'type' => $request['type'],
                'updated_at' => Carbon::now(),
            ];
            return Faq::where('id', $id)->update($data);
        } catch (\Exception $e) {
            return false;
        }
    }
}