<?php

namespace App\Repositories\Admin;

use App\Models\Category;
use App\Repositories\Interfaces\Admin\CategoryInterface;
use Carbon\Carbon;
use App\Traits\ImageTrait;
use Illuminate\Support\Str;

class CategoryRepository implements CategoryInterface
{
    use ImageTrait;

    public function all()
    {
        return Category::get();
    }

    public function store($request) {
        try {
            $data = [
                'video_type' => $request['video_type'],
                'video_type_desc' => $request['video_type_desc'],
                'primary_menu' => $request['primary_menu'],
                'footer_menu' => $request['footer_menu'],
                'slug' => Str::slug($request['video_type']),
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ];
            return Category::create($data);
        } catch (\Exception $e) {
            return false;
        }
    }

    public function update($request, $id) {
        try {
            $data = [
                'video_type' => $request['video_type'],
                'video_type_desc' => $request['video_type_desc'],
                'primary_menu' => $request['primary_menu'],
                'footer_menu' => $request['footer_menu'],
                'slug' => Str::slug($request['video_type']),
                'updated_at' => Carbon::now(),
            ];
            return Category::where('id', $id)->update($data);
        } catch (\Exception $e) {
            return false;
        }
    }
}