<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class PlayList extends Model
{
    protected $fillable = [
        'user_id',
        'name',
        'thumbnail',
        'slug'
    ];
    protected $casts = [
        'thumbnail' => 'array',
    ];
    public function movies()
    {
        return $this->belongsToMany(Movie::class, 'play_list_movies')->withTimestamps();
    }
    public function user()
    {
        return $this->belongsTo(User::class);
    }
    public function scopeWithMovieCount($query)
    {
        return $query->withCount('movies');
    }

}
