<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Package extends Model
{
    protected $fillable = [
        'name',
        'day',
        'screens',
        'price',
        'status',
        'type',
        'discount',
        'stripe',
        'paypal',
        'paddle',
        'razor_pay',
        'revenue_cat_id'
    ];

    public function stripe()
    {
        return $this->hasOne(PlanCredential::class, 'plan_id')->where('title', 'stripe');
    }

    public function paypal()
    {
        return $this->hasOne(PlanCredential::class, 'plan_id')->where('title', 'paypal');
    }

    public function paddle()
    {
        return $this->hasOne(PlanCredential::class, 'plan_id')->where('title', 'paddle');
    }

    public function razor_pay()
    {
        return $this->hasOne(PlanCredential::class, 'plan_id')->where('title', 'razor_pay');
    }
}
