<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class LiveTv extends Model
{
    protected $fillable = [
        'tv_name',
        'live_tv_category_id',
        'country_id',
        'description',
        'slug',
        'status',
        'featured',
        'stream_from',
        'stream_from1',
        'stream_from2',
        'stream_label',
        'stream_label1',
        'stream_label2',
        'stream_url',
        'stream_url1',
        'stream_url2',
        'seo_title',
        'meta_description',
        'focus_keyword',
        'tags',
        'thumbnail'
    ];
  
    public function stream1()
    {
        return $this->hasOne(LiveTvUrl::class, 'live_tv_id', 'id')->where('url_for', 'op1');
    }
    public function stream2()
    {
        return $this->hasOne(LiveTvUrl::class, 'live_tv_id', 'id')->where('url_for', 'op2');
    }
    public function category()
    {
        return $this->belongsTo(LiveTvCategory::class, 'live_tv_category_id', 'id');
    }
    public function country()
    {
        return $this->belongsTo(Country::class);
    }
    public function favoritedByUsers()
    {
        return $this->belongsToMany(User::class, 'favorite_live_tvs');
    }
    public function reviews()
    {
        return $this->morphMany(Review::class, 'reviewable');
    }
}
