<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Episode extends Model
{
    protected $fillable = [
        'episode_name',
        'order',
        'source_type',
        'description',
        'file_url',
        'season_id',
        'poster',
        'slug',
        'series_id',
        'runtime'
    ];
    public function downloadLinks()
    {
        return $this->morphMany(DownloadLink::class, 'downloadable');
    }

    public function season()
    {
        return $this->belongsTo(Season::class, 'season_id'); // Changed from series_id
    }

    public function tvshow()
    {
        return $this->belongsTo(TvShow::class, 'tv_show_id');
    }
}
