<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class CustomerQuery extends Model
{
    protected $fillable = [
        'name',
        'email',
        'subject',
        'message',
        'status'
    ];

    public function replies()
    {
        return $this->hasMany(CustomerQueryReply::class);
    }

    public function latestReply()
    {
        return $this->hasOne(CustomerQueryReply::class)->latestOfMany();
    }
}
