<?php

namespace App\Mail;

use App\Models\CustomerQuery;
use App\Models\CustomerQueryReply;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class CustomerQueryReplied extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * Create a new message instance.
     */
    public $query;
    public $reply;
    public function __construct(CustomerQuery $query, CustomerQueryReply $reply)
    {
        $this->query = $query;
        $this->reply = $reply;
    }

    public function build(): CustomerQueryReplied
    {
        return $this->subject('Your Query Has Been Replied')
            ->view('emails.customer_query_reply')
            ->with([
                'query' => $this->query,
                'reply' => $this->reply,
            ]);
    }

}





