<?php

namespace App\Http\Resources\Website;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class PlayListResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $thumbnail = is_array($this->thumbnail) ? $this->thumbnail : json_decode($this->thumbnail, true);

        return [
            'id' => $this->id,
            'user_id' => $this->user_id,
            'name' => $this->name,
            'thumbnail' => isset($thumbnail['image_240x240'])
                ? static_asset($thumbnail['image_240x240'])
                : (isset($thumbnail['original_image']) ? $thumbnail['original_image']
                    : null),
            'total_video' => $this->movies_count,
        ];
    }

}
