<?php

namespace App\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;

class VideoFileRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        $rules = [
            'label' => 'required|string|max:50',
            'order' => 'required|integer|min:1|max:100',
            'source' => 'required|string|max:10',
        ];

        if ($this->input('source') === 'local') {
            $rules['video_file'] = 'nullable|file|mimetypes:video/*';
            $rules['file_url'] = 'nullable|string|max:255';
        } else {
            $rules['video_file'] = 'nullable|file|mimetypes:video/*';
            $rules['file_url'] = 'required|url|max:255';
        }

        return $rules;
    }
}
