<?php

namespace App\Http\Requests\Admin;

use GuzzleHttp\Psr7\Request;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rules;

class TvShowRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
       
        return [
            'title' => 'required|string|max:191',
            'slug'  => 'required|string|max:191',
            'seo_title'      => 'nullable|string|max:191',
            'rating'      => 'nullable|integer|max:10',
            'release_date'      => 'required|date',
            'country'      => 'required|string|max:191',
            'genre'      => 'required|string|max:191',
            'actor'      => 'required|string|max:191',
            'director'      => 'required|string|max:191',
            'writer'      => 'required|string|max:191',
            'video_type'      => 'required|string|max:50',
            'video_quality'      => 'required|string|max:50',
            'runtime'      => 'required|integer|max:10',
            'language'      => 'required |integer|max:20',
            'imdb_rating'    => 'nullable|integer|max:10',
            'thumbnail'      => 'nullable|mimes:jpg,JPG,JPEG,jpeg,png,PNG,webp,WEBP|max:20480',
            'poster'      => 'nullable|mimes:jpg,JPG,JPEG,jpeg,png,PNG,webp,WEBP|max:20480',
        ];
    }
}