<?php

namespace App\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class PageRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $id = $this->route('id'); // or $this->id, depending on how you're passing the ID

        return [
            'title' => 'required|string|max:191',
            'meta_description' => 'required|string|max:191',
            'link' => [
                'required', 'string', 'max:191',
                Rule::unique('pages', 'link')->ignore($id),
            ],
        ];
    }
}
