<?php

namespace App\Http\Requests\Admin;

use GuzzleHttp\Psr7\Request;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rules;

class MovieRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
       
        return [
            'title' => 'required|string|max:150',
            'slug'  => 'nullable|string|max:191',
            'seo_title'      => 'nullable|string|max:191',
            'rating'      => 'nullable|integer|max:5',
            'release'      => 'nullable|date|max:25',
            'country'      => 'required|integer|max:20',
            'language'      => 'required|integer|max:20',
            'genre'      => 'required|integer|max:191',
            'actor'      => 'required|integer|max:191',
            'director'      => 'required|integer|max:191',
            'writer'      => 'required|integer|max:191',
            'video_type'      => 'required|integer|max:50',
            'video_quality'      => 'required|max:50',
            'runtime'      => 'required|integer|max:10',
            'imdb_rating'    => 'nullable|integer|max:5',
            'thumbnail'      => 'nullable|mimes:jpg,JPG,JPEG,jpeg,png,PNG,webp,WEBP|max:20480',
            'poster'      => 'nullable|mimes:jpg,JPG,JPEG,jpeg,png,PNG,webp,WEBP|max:20480',
            'is_free' => 'nullable|integer|max:10',
            'description'      => 'nullable|string|max:500',
            'tags'      => 'nullable|string|max:191',
            'trailer_url'      => 'nullable|string|max:191',
            'status'      => 'nullable|integer|max:10',
            'featured'      => 'nullable|max:10|integer',
        ];
    }
}