<?php

namespace App\Http\Requests\admin;

use App\Models\MovieIndustry;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class MovieIndustryRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'name' => [
                'required',
                'string',
                'max:255',
                Rule::unique(MovieIndustry::class)->ignore($this->route('movie_industry')?->id),
            ],
            'country_id' => [
                'required',
                'exists:countries,id',
            ],

        ];
    }
}
