<?php

namespace App\Http\Requests\Admin;

use GuzzleHttp\Psr7\Request;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rules;

class GenreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
       
        return [
            'name' => 'required|string|max:50',
            'slug'  => 'nullable|max:191',
            'description'      => 'nullable|string|max:500',
            'status'      => 'nullable|integer|max:20',
            'featured'      => 'nullable|integer|max:20',
            'icon'      => 'nullable|file|mimes:jpg,jpeg,png|max:20480',
        ];
    }
}