<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use App\Repositories\Interfaces\Website\FavoriteRepositoryInterface;
use Exception;
use App\Http\Requests\Website\FavoriteRequest;
use Illuminate\Support\Facades\Log;

class FavoriteController extends Controller
{
    protected $favoriteRepo;

    public function __construct(FavoriteRepositoryInterface $favoriteRepo)
    {
        $this->favoriteRepo = $favoriteRepo;

    }
    public function getFavorites()
    {
        return $this->favoriteRepo->getFavorites();
    }

    public function toggleFavorite(FavoriteRequest $request)
    {
        try {
            $type = $request->input('type'); // 'movie', 'tv_show', or 'live_tv'
            $id = $request->input('id');

            $status = $this->favoriteRepo->toggleFavorite($type, $id);

            return response()->json([
                'status' => 'success',
                'toggle_status' => $status,
                'message' => __('favorite_' . $status . '_successfully')
            ], 200);
        } catch (Exception $e) {
            Log::error('Error saving favorite list: ' . $e->getMessage());
            return response()->json([
                'status' => 'error',
                'message' => __('error_adding_to_favorite_list')
            ], 500);
        }
    }
}
