<?php

namespace App\Http\Controllers\Api\Mobile;

use App\Http\Controllers\Controller;
use App\Models\Ads;
use App\Models\Currency;
use Illuminate\Http\Request;
use App\Traits\Mobile\ApiResponseTrait;

class SettingController extends Controller
{
    use ApiResponseTrait;

    public function get_config(Request $request)
    {
        $data = [
            'currency_symbol' => Currency::where('id', get_config('currency_symbol'))->first()->symbol ?? '$',
            'google_drive_api_key' => get_config('google_api_key'),
            'banner_ads' => get_config('banner_ads'),
            'banner_ads_id' => get_config('banner_ads_id'),
            'interstitial_ads' => get_config('interstitial_ads'),
            'interstitial_ads_id' => get_config('interstitial_ads_id'),
            'stripe_key' => get_config('stripe_key'),
            'stripe_secret' => get_config('stripe_secret'),
        ];
        return $this->responseWithSuccess($data, __('config_retrieved_successfully'));
    }

    public function get_ads(Request $request)
    {
        $withMedia = function ($item) {
            $item->banner = apiImage(optional(json_decode($item->banner))->original_image, 'adss');
            $item->poster = apiImage(optional(json_decode($item->poster))->original_image, 'adss');
            return $item;
        };
        $ads = Ads::where('status', 1)
            ->where('start_date', '<=', now())
            ->where('end_date', '>=', now())
            ->get()
            ->transform($withMedia);
        $data = [
            'ads' => $ads,
        ];
        if ($ads) {
            return $this->responseWithSuccess($data, __('ads_retrieved_successfully'));
        } else {
            return $this->responseWithError(__('no_ads_available'), 404);
        }
    }
}
