<?php

namespace App\Http\Controllers\Api\Mobile;

use App\Http\Controllers\Controller;
use App\Models\Interest;
use App\Models\User;
use App\Traits\Mobile\ApiResponseTrait;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class InterestController extends Controller
{
    use ApiResponseTrait;

    // public function __contractor(Request $request) {
    //     $request->user()->currentAccessToken();
    // }

    public function interest() {
        $interest = Interest::where('status', 1)->get();
        return $this->responseWithSuccess(['interests' => $interest], __('interest_retrieve_successfully'));
    }

    public function store(Request $request) {
        // Validate input
        $validator = Validator::make($request->all(), [
            'email' => 'required|email',
            'interest_ids' => 'required',
        ]);
        if ($validator->fails()) {
            return $this->responseWithValidation($validator->errors(), 422);
        }
        if(is_array($request->interest_ids)) {
            User::where('email', $request->email)->update(['interests' => json_encode($request->interest_ids)]);
            return $this->responseWithSuccess(['details' => ''], __('interest_update_successfully'));
        }
        return $this->responseWithError(__('interest_ids_need_to_be_array'), 400);
    }
}
