<?php

namespace App\Http\Controllers\Api\Mobile;

use App\Http\Controllers\Controller;
use App\Repositories\Interfaces\Website\FavoriteRepositoryInterface;
use App\Traits\Mobile\ApiResponseTrait;
use Exception;
use App\Http\Requests\Website\FavoriteRequest;
use Illuminate\Support\Facades\Log;

class FavoriteController extends Controller
{
    use ApiResponseTrait;

    protected $favoriteRepo;

    public function __construct(FavoriteRepositoryInterface $favoriteRepo)
    {
        $this->favoriteRepo = $favoriteRepo;

    }
    public function getFavorites()
    {
        $data = $this->favoriteRepo->getFavorites();

        return $this->responseWithSuccess(
            $data,
            __("favorite_list")
        );

    }
    public function toggleFavorite(FavoriteRequest $request)
    {
        try {
            $type = $request->input('type'); // 'movie', 'tv_show', or 'live_tv'
            $id = $request->input('id');

            $status = $this->favoriteRepo->toggleFavorite($type, $id);


            return $this->responseWithSuccess(
                [],
                __("favorite_status_successfully", ['status' => $status])
            );
        } catch (Exception $e) {
            Log::error('Error saving favorite list: ' . $e->getMessage());


            return $this->responseWithError(
                __('favorite_error_message'),
                400
            );

        }
    }
}

