<?php

namespace App\Http\Controllers\Admin;

use App\DataTables\Admin\VideoQualityDataTable;
use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\VideoQualityRequest;
use App\Models\VideoQuality;
use App\Repositories\Interfaces\Admin\VideoQualityInterface;
use Illuminate\Http\Request;

class VideoQualityController extends Controller
{
    protected $video_qualities;

    public function __construct(VideoQualityInterface $video_qualities) {
        $this->video_qualities = $video_qualities;
    }

    public function index(VideoQualityDataTable $dataTable) {
        return $dataTable->render('admin.video_quality.index');
    }

    public function add() {
        return view('admin.video_quality.add');
    }

    public function store(VideoQualityRequest $request){
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        $this->video_qualities->store($request->all());
        $data = [
            'status'    => 'success',
            'message'   => __('video_quality_created_successfully'),
            'title'     => __('success'),
            'is_reload' => true,
        ];
        return response()->json($data);
    }

    public function status(Request $request){
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        VideoQuality::where('id', $request->id)->update(['status' => $request->status]);
        $data = [
            'status'    => 'success',
            'message'   => __('video_quality_status_update_successfully'),
            'title'     => __('success'),
            'is_reload' => false,
        ];
        return response()->json($data);
    }

    public function edit($id) {
        $data['quality'] = VideoQuality::where('id', $id)->first();
        return view('admin.video_quality.edit', $data);
    }

    public function update(VideoQualityRequest $request, $id) {
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        $this->video_qualities->update($request->all(), $id);
        $data = [
            'status'    => 'success',
            'message'   => __('video_quality_update_successfully'),
            'title'     => __('success'),
            'is_reload' => true,
        ];
        return response()->json($data);
    }

    public function delete($id) {
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        $qualityDelete = VideoQuality::where('id', $id)->delete();
        if($qualityDelete) {
            $data = [
                'title'  => __('success'),
                'status'  => true,
                'message' => __('package_deleted_successfully'),
                'is_reload' => true,
            ];
            return $data;
        }
        return false;
    }
}
