<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Traits\UpdateTrait;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Artisan;

class UtilityController extends Controller
{
    use UpdateTrait;

    public function serverInfo(): \Illuminate\Contracts\View\Factory|\Illuminate\Contracts\View\View|\Illuminate\Contracts\Foundation\Application
    {

        return view('admin.utility.server_info');
    }

    public function systemUpdate(): \Illuminate\Contracts\View\View|\Illuminate\Contracts\View\Factory|\Illuminate\Http\RedirectResponse|\Illuminate\Contracts\Foundation\Application
    {
        try {
            $url = 'https://license.spagreen.net/version-check';
            $fields = [
                'item_id' => '59566505',
                'activation_code' => get_config('activation_code'),
                'current_version' => get_config('current_version'),
            ];

            $response = false;
            if (config('app.beta_channel')):
                $url = 'https://license.spagreen.net/version-check-including-beta';
            endif;
            $request = curlRequest($url, $fields);
            if (property_exists($request, 'status') && $request->status) {
                $response = $request->release_info;
            }
            if (is_bool($response)) {
                $latest_version = get_config('current_version');
                $is_old = get_config('current_version') < $latest_version;
                $next_version_code = 'v' . implode('.', str_split((int) get_config('current_version')));
                $next_version = (int) get_config('current_version');
            } else {
                $latest_version = $response->version;
                $is_old = get_config('current_version') < $latest_version;
                $next_version = (int) $latest_version;
                $next_version_code = 'v' . implode('.', str_split($next_version));
            }

            $data = [
                'response' => $response,
                'latest_version' => get_config('current_version'),
                'is_old' => $is_old,
                'next_version' => $next_version,
                'next_version_code' => $next_version_code,
            ];
            return view('admin.utility.system_update', $data);
        } catch (\Exception $e) {
            return redirect()->back()->with('toastr_error', preg_replace('/[^A-Za-z0-9 ]/', '', strip_tags($e->getMessage())));
        }
    }

    public function downloadUpdate(Request $request): \Illuminate\Http\JsonResponse
    {
       if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        try {

            $update = $this->downloadUpdateFile($request->all());

            if (is_string($update)) {
                Artisan::call('migrate', ['--force' => true]);
                Artisan::call('cache:clear');
                Artisan::call('config:clear');
                Artisan::call('route:clear');
                Artisan::call('view:clear');
                return response()->json([
                    'message' => $update,
                    'type' => __('Error') . ' !',
                    'class' => 'danger',
                ]);
            }

            return response()->json([
                'type' => __('Success') . ' !',
                'class' => 'success',
                'message' => __('Update Successfully'),
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'type' => __('Error') . ' !',
                'class' => 'danger',
                'message' => $e->getMessage(),
            ]);
        }
    }
}
