<?php

namespace App\Http\Controllers\Admin;

use App\DataTables\Admin\SubscriberDataTable;
use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\SubscriberRequest;
use App\Models\User;
use App\Repositories\Interfaces\Admin\SubscriberInterface;
use Illuminate\Http\Request;

class SubscriberController extends Controller
{
    protected $subscribers;

    public function __construct(SubscriberInterface $subscribers) {
        $this->subscribers = $subscribers;
    }


    public function index(SubscriberDataTable $dataTable) {
        return $dataTable->render('admin.subscriber.index');
    }

    public function add() {
        return view('admin.subscriber.add');
    }

    public function store(SubscriberRequest $request){
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        $this->subscribers->store($request->all());
       
        return redirect()->route('admin.subscribers');
    }

    public function status(Request $request){
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        User::where('id', $request->id)->update(['status' => $request->status]);
        $data = [
            'status'    => 'success',
            'message'   => __('subscriber_status_update_successfully'),
            'title'     => __('success'),
            'is_reload' => false,
        ];
        return response()->json($data);
    }

    public function edit($id) {
        $data['subscriber'] = User::where('id', $id)->first();
        return view('admin.subscriber.edit', $data);
    }

    public function update(SubscriberRequest $request, $id) {
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        $this->subscribers->update($request->all(), $id);
        
        return redirect()->route('admin.subscribers');
    }

    public function delete($id) {
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        $subscriberDelete = User::where('id', $id)->delete();
        if($subscriberDelete) {
            $data = [
                'title'  => __('Success'),
                'status'  => true,
                'message' => __('subscriber_deleted_successfully'),
                'is_reload' => true,
            ];
            return $data;
        }
        return false;
    }
}
