<?php

namespace App\Http\Controllers\Admin;

use App\DataTables\Admin\StaffDataTable;
use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\StaffRequest;
use App\Models\Permission;
use App\Models\User;
use App\Repositories\Interfaces\Admin\PermissionInterface;
use App\Repositories\Interfaces\Admin\RoleInterface;
use App\Repositories\Interfaces\Admin\StaffInterface;
use App\Traits\ImageTrait;
use Illuminate\Http\Request;

class StaffController extends Controller
{
    protected $staffs;
    protected $role;
    protected $permission;

    use ImageTrait;

    public function __construct(StaffInterface $staffs, RoleInterface $role, PermissionInterface $permission)
    {
        $this->staffs = $staffs;
        $this->role = $role;
        $this->permission = $permission;

    }

    public function index(StaffDataTable $dataTable)
    {
        return $dataTable->render('admin.staff.index');
    }

    public function add()
    {
        $permissions = $this->permission->all();
        $roles = $this->role->staffRoll();
        $data = [
            'permissions' => $permissions,
            'roles' => $roles,
        ];
        return view('admin.staff.add', $data);
    }

    public function changeRole(Request $request)
    {
        $role_permissions = $this->role->get($request->role_id)->permissions;
        $permissions = $this->permission->all();

        return view('.admin.staff.permissions', compact('permissions', 'role_permissions'))->render();
    }
    public function store(StaffRequest $request)
    {
        if (isDemoMode()) {
            session()->flash('toastr_success', 'This action is disabled in demo mode.');

            return redirect()->route('admin.staffs');
        }
        $this->staffs->store($request->all());

        session()->flash('toastr_success', __('staff_added_successfully'));

        return redirect()->route('admin.staffs');
    }

    public function status(Request $request)
    {
        if (isDemoMode()) {
            session()->flash('toastr_success', 'This action is disabled in demo mode.');

            return redirect()->route('admin.staffs');
        }
        User::where('id', $request->id)->update(['status' => $request->status]);
        $data = [
            'status' => 'success',
            'message' => __('user_status_update_successfully'),
            'title' => __('success'),
            'is_reload' => false,
        ];
        return response()->json($data);
    }

    public function edit($id)
    {

        $staff = User::where('id', $id)->first();
        $permissions = Permission::all();
        $roles = $this->role->staffRoll();
        $data = [
            'permissions' => $permissions,
            'roles' => $roles,
            'staff' => $staff,
        ];
        return view('admin.staff.edit', $data);
    }

    public function update(StaffRequest $request, $id)
    {
        if (isDemoMode()) {
            session()->flash('toastr_success', 'This action is disabled in demo mode.');

            return redirect()->route('admin.staffs');
        }
        $this->staffs->update($request->all(), $id);

        session()->flash('toastr_success', __('staff_updated_successfully'));

        return redirect()->route('admin.staffs');
    }

    public function delete($id)
    {
        if (isDemoMode()) {
            session()->flash('toastr_success', 'This action is disabled in demo mode.');

            return redirect()->route('admin.staffs');
        }
        $this->imageDelete($id, 'user', 'image');
        $languageDelete = User::where('id', $id)->delete();
        if ($languageDelete) {
            $data = [
                'title' => __('Success'),
                'status' => true,
                'message' => __('staff_deleted_successfully'),
                'is_reload' => true,
            ];
            return $data;
        }
        return false;
    }
}
