<?php

namespace App\Http\Controllers\Admin;

use App\DataTables\Admin\SeasonDataTable;
use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\SeasonRequest;
use App\Models\Season;
use App\Repositories\Interfaces\Admin\SeasonInterface;
use Illuminate\Http\Request;

class SeasonController extends Controller
{
    protected $seasons;

    public function __construct(SeasonInterface $seasons) {
        $this->seasons = $seasons;
    }

    public function index(SeasonDataTable $dataTable) {
        return $dataTable->render('admin.tv_show.season.index');
    }

    public function add() {
        return view('admin.tv_show.season.add');
    }

    public function store(SeasonRequest $request){
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        $this->seasons->store($request->all());
        $data = [
            'status'    => 'success',
            'message'   => __('season_created_successfully'),
            'title'     => __('success'),
            'is_reload' => true,
        ];
        return response()->json($data);
    }

    public function edit($id) {
        $data['season'] = Season::where('id', $id)->first();
        return view('admin.tv_show.season.edit', $data);
    }

    public function update(SeasonRequest $request, $id) {
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        $this->seasons->update($request->all(), $id);
        $data = [
            'status'    => 'success',
            'message'   => __('season_update_successfully'),
            'title'     => __('success'),
            'is_reload' => true,
        ];
        return response()->json($data);
    }

    public function delete($id) {
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        $seasonDelete = Season::where('id', $id)->delete();
        if($seasonDelete) {
            $data = [
                'title'  => __('success'),
                'status'  => true,
                'message' => __('season_deleted_successfully'),
                'is_reload' => true,
            ];
            return $data;
        }
        return false;
    }


}
