<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;
use App\Traits\ImageTrait;
use App\Traits\ProfileTrait;
use Illuminate\Http\UploadedFile;

class ProfileController extends Controller
{

    use ImageTrait;
    use ProfileTrait;

    public function index()
    {
        return view('admin.profile.manage_profile');
    }

    public function update_profile(Request $request)
    {
if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        $request->validate([
            'first_name' => 'required|string|max:30',
            'last_name' => 'required|string|max:30',
            'email' => 'required|email|max:30',
            'phone' => 'nullable|string|max:15',
        ]);

        $this->profile_update($request->all());

        $data = [
            'status'    => 'success',
            'message'   => __('profile_update_successfully'),
            'title'     => __('success'),
            'is_reload' => true,
        ];
        return response()->json($data);
    }

    public function change_password()
    {
        return view('admin.profile.change_password');
    }

    public function password_update(Request $request)
    {
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        $request->validate([
            'current_password' => 'required|string|min:8',
            'new_password' => 'required|string|min:8|confirmed',
        ]);

        $this->profile_password_update($request->all());
        
        return response()->json([
            'status' => 'success',
            'message' => __('password_update_successfully'),
            'title' => __('success'),
            'is_reload' => true,
        ]);
    }
}
