<?php

namespace App\Http\Controllers\Admin;

use App\DataTables\Admin\PackageDataTable;
use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\PackageRequest;
use App\Models\Package;
use App\Repositories\Interfaces\Admin\PackageInterface;
use Illuminate\Http\Request;

class PackageController extends Controller
{
    protected $packages;

    public function __construct(PackageInterface $packages) {
        $this->packages = $packages;
    }

    public function index(PackageDataTable $dataTable) {
        return $dataTable->render('admin.package.index');
    }

    public function add() {
        return view('admin.package.add');
    }

    public function store(Request $request){
if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        $this->packages->store($request->all());
        $data = [
            'status'    => 'success',
            'message'   => __('package_created_successfully'),
            'title'     => __('success'),
            'is_reload' => true,
        ];
        return response()->json($data);
    }

    public function status(Request $request){
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        Package::where('id', $request->id)->update(['status' => $request->status]);
        $data = [
            'status'    => __('success'),
            'message'   => __('package_update_successfully'),
            'title'     => __('success'),
            'is_reload' => false,
        ];
        return response()->json($data);
    }

    public function edit($id) {
        $data['package'] = Package::where('id', $id)->first();
        return view('admin.package.edit', $data);
    }

    public function update(PackageRequest $request, $id) {
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        $this->packages->update($request->all(), $id);
        $data = [
            'status'    => 'success',
            'message'   => __('package_update_successfully'),
            'title'     => __('success'),
            'is_reload' => true,
        ];
        return response()->json($data);
    }

    public function delete($id) {
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        $packageDelete = Package::where('id', $id)->delete();
        if($packageDelete) {
            $data = [
                'title'  => __('success'),
                'status'  => true,
                'message' => __('package_deleted_successfully'),
                'is_reload' => true,
            ];
            return $data;
        }
        return false;
    }
}
