<?php

namespace App\Http\Controllers\admin;

use App\DataTables\Admin\MovieIndustryDataTable;
use App\Http\Controllers\Controller;
use App\Http\Requests\admin\MovieIndustryRequest;
use App\Models\MovieIndustry;
use App\Repositories\Interfaces\Admin\MovieIndustryInterface;
use Illuminate\Http\Request;

class MovieIndustryController extends Controller
{
    protected $movieIndustryRepo;

    public function __construct(MovieIndustryInterface $movieIndustryRepo)
    {
        $this->movieIndustryRepo = $movieIndustryRepo;
    }

    public function index(MovieIndustryDataTable $dataTable)
    {
        return $dataTable->render('admin.movie_industries.index');
    }

    public function add()
    {
        return view('admin.movie_industries.add');
    }

    public function edit($id)
    {
        $data['movieIndustry'] = MovieIndustry::where('id', $id)->first();
        return view('admin.movie_industries.edit', $data);
    }

    public function store(MovieIndustryRequest $request)
    {
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        if(!auth()->user()->can('admin.language.delete')){
            $data = [
                'status'    => 'error',
                'message'   => __('you_are_not_authorized_to_perform_this_action'),
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        $this->movieIndustryRepo->store($request->all());
        $data = [
            'status' => 'success',
            'message' => __('movie_industry_added_successfully'),
            'title' => __('success'),
            'is_reload' => true,
        ];
        return response()->json($data);
    }

    public function update(MovieIndustryRequest $request, $id)
    {
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        $this->movieIndustryRepo->update($request->all(), $id);
        $data = [
            'status' => 'success',
            'message' => __('movie_industry_update_successfully'),
            'title' => __('success'),
            'is_reload' => true,
        ];
        return response()->json($data);
    }

    public function status(Request $request)
    {
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        MovieIndustry::where('id', $request->id)->update(['status' => $request->status]);
        $data = [
            'status' => 'success',
            'message' => __('movie_industry_status_update_successfully'),
            'title' => __('success'),
            'reload' => false,
        ];
        return response()->json($data);
    }

    public function delete($id)
    {
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        if(!auth()->user()->can('admin.movie_industry.delete')){
            $data = [
                'status'    => 'error',
                'message'   => __('you_are_not_authorized_to_perform_this_action'),
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        $starDelete = MovieIndustry::where('id', $id)->delete();
        if ($starDelete) {
            $data = [
                'title' => __('Success'),
                'status' => true,
                'message' => __('movie_industry_delete_successfully'),
                'is_reload' => true,
            ];
            return $data;
        }
        return false;
    }
}
