<?php

namespace App\Http\Controllers\Admin;

use App\DataTables\Admin\LiveTvDataTable;
use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\LiveTvRequest;
use App\Models\LiveTv;
use App\Models\LiveTvCategory;
use App\Repositories\Interfaces\Admin\LiveTvInterface;
use App\Traits\ImageTrait;
use Illuminate\Http\Request;

class LiveTvController extends Controller
{
    protected $live_tvs;
    use ImageTrait;

    public function __construct(LiveTvInterface $live_tvs)
    {
        $this->live_tvs = $live_tvs;
    }

    public function index(LiveTvDataTable $dataTable)
    {
        return $dataTable->render('admin.live_tv.index');
    }

    public function add()
    {
        $data['categories'] = LiveTvCategory::where('status', 1)->get();
        return view('admin.live_tv.add', $data);
    }

    public function store(LiveTvRequest $request)
    {
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        try {
            $this->live_tvs->store($request->all());
            session()->flash('toastr_success', 'live_tv_created_successful!');
            return redirect()->route('admin.live.tvs');

        } catch (\Exception $e) {
            \Log::error('LiveTV Store Error: ' . $e->getMessage());
            session()->flash('toastr_danger', $e->getMessage());
            return redirect()->back()->withInput();
        }

    }


    public function update(LiveTvRequest $request, $id)
    {
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        try {
            $this->live_tvs->update($request->all(), $id);
            session()->flash('toastr_success', 'live_tv_updated_successful!');
            return redirect()->route('admin.live.tvs');
        } catch (\Exception $e) {
            \Log::error('LiveTV Store Error: ' . $e->getMessage());
            session()->flash('toastr_error', $e->getMessage());
            return redirect()->back();

        }
    }

    public function status(Request $request)
    {
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        LiveTv::where('id', $request->id)->update(['status' => $request->status]);
        $data = [
            'status' => 'success',
            'message' => __('live_tv_status_update_successfully'),
            'title' => __('success'),
            'is_reload' => false,
        ];
        return response()->json($data);
    }

    public function feature(Request $request)
    {
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        LiveTv::where('id', $request->id)->update(['featured' => $request->featured]);
        $data = [
            'status' => 'success',
            'message' => __('live_tv_feature_update_successfully'),
            'title' => __('success'),
            'is_reload' => false,
        ];
        return response()->json($data);
    }

    public function edit($id)
    {
        $data['categories'] = LiveTvCategory::where('status', 1)->get();
        $data['live_tv'] = LiveTv::where('id', $id)->first();
        return view('admin.live_tv.edit', $data);
    }

    public function delete($id)
    {
        if (isDemoMode()) {
            $data = [
                'status'    => 'error',
                'message'   => 'This action is disabled in demo mode.',
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        if(!auth()->user()->can('admin.language.delete')){
            $data = [
                'status'    => 'error',
                'message'   => __('you_are_not_authorized_to_perform_this_action'),
                'title'     => __('error'),
                'is_reload' => false,
            ];
            return response()->json($data);
        }
        $this->imageDelete($id, 'liveTv', 'thumbnail');
        $tvDelete = LiveTv::where('id', $id)->delete();
        if ($tvDelete) {
            $data = [
                'title' => __('Success'),
                'status' => true,
                'message' => __('tv_live_delete_delete_successfully'),
                'is_reload' => true,
            ];
            return $data;
        }
        return false;
    }

}
